/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message.modifier.checksum;

import java.util.zip.Checksum;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.message.modifier.AbstractSyslogMessageModifier;
import org.productivity.java.syslog4j.impl.message.modifier.checksum.ChecksumSyslogMessageModifierConfig;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class ChecksumSyslogMessageModifier
extends AbstractSyslogMessageModifier {
    private static final long serialVersionUID = -3268914290497005065L;
    protected ChecksumSyslogMessageModifierConfig config = null;

    public static final ChecksumSyslogMessageModifier createCRC32() {
        ChecksumSyslogMessageModifier checksumSyslogMessageModifier = new ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig.createCRC32());
        return checksumSyslogMessageModifier;
    }

    public static final ChecksumSyslogMessageModifier createADLER32() {
        ChecksumSyslogMessageModifier checksumSyslogMessageModifier = new ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig.createADLER32());
        return checksumSyslogMessageModifier;
    }

    public ChecksumSyslogMessageModifier(ChecksumSyslogMessageModifierConfig checksumSyslogMessageModifierConfig) {
        super(checksumSyslogMessageModifierConfig);
        this.config = checksumSyslogMessageModifierConfig;
        if (this.config == null) {
            throw new SyslogRuntimeException("Checksum config object cannot be null");
        }
        if (this.config.getChecksum() == null) {
            throw new SyslogRuntimeException("Checksum object cannot be null");
        }
    }

    public ChecksumSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    protected void continuousCheckForVerify() {
        if (this.config.isContinuous()) {
            throw new SyslogRuntimeException(this.getClass().getName() + ".verify(..) does not work with isContinuous() returning true");
        }
    }

    public boolean verify(String string, String string2) {
        this.continuousCheckForVerify();
        long l = Long.parseLong(string2, 16);
        return this.verify(string, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String string, long l) {
        this.continuousCheckForVerify();
        Checksum checksum = this.config.getChecksum();
        synchronized (checksum) {
            this.config.getChecksum().reset();
            byte[] byArray = SyslogUtility.getBytes(this.config, string);
            this.config.getChecksum().update(byArray, 0, string.length());
            return this.config.getChecksum().getValue() == l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modify(SyslogIF syslogIF, int n, int n2, String string) {
        Checksum checksum = this.config.getChecksum();
        synchronized (checksum) {
            StringBuffer stringBuffer = new StringBuffer(string);
            byte[] byArray = SyslogUtility.getBytes(syslogIF.getConfig(), string);
            if (!this.config.isContinuous()) {
                this.config.getChecksum().reset();
            }
            this.config.getChecksum().update(byArray, 0, string.length());
            stringBuffer.append(this.config.getPrefix());
            stringBuffer.append(Long.toHexString(this.config.getChecksum().getValue()).toUpperCase());
            stringBuffer.append(this.config.getSuffix());
            return stringBuffer.toString();
        }
    }
}

