/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message.modifier.mac;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.message.modifier.AbstractSyslogMessageModifier;
import org.productivity.java.syslog4j.impl.message.modifier.mac.MacSyslogMessageModifierConfig;
import org.productivity.java.syslog4j.util.Base64;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class MacSyslogMessageModifier
extends AbstractSyslogMessageModifier {
    private static final long serialVersionUID = 5054979194802197540L;
    protected MacSyslogMessageModifierConfig config = null;
    protected Mac mac = null;

    public MacSyslogMessageModifier(MacSyslogMessageModifierConfig macSyslogMessageModifierConfig) throws SyslogRuntimeException {
        super(macSyslogMessageModifierConfig);
        this.config = macSyslogMessageModifierConfig;
        try {
            this.mac = Mac.getInstance(macSyslogMessageModifierConfig.getMacAlgorithm());
            this.mac.init(macSyslogMessageModifierConfig.getKey());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SyslogRuntimeException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SyslogRuntimeException(invalidKeyException);
        }
    }

    public static MacSyslogMessageModifier createHmacSHA1(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA1(key));
    }

    public static MacSyslogMessageModifier createHmacSHA1(String string) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA1(string));
    }

    public static MacSyslogMessageModifier createHmacSHA256(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA256(key));
    }

    public static MacSyslogMessageModifier createHmacSHA256(String string) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA256(string));
    }

    public static MacSyslogMessageModifier createHmacSHA512(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA512(key));
    }

    public static MacSyslogMessageModifier createHmacSHA512(String string) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA512(string));
    }

    public static MacSyslogMessageModifier createHmacMD5(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacMD5(key));
    }

    public static MacSyslogMessageModifier createHmacMD5(String string) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacMD5(string));
    }

    public MacSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modify(SyslogIF syslogIF, int n, int n2, String string) {
        Mac mac = this.mac;
        synchronized (mac) {
            byte[] byArray = SyslogUtility.getBytes(syslogIF.getConfig(), string);
            StringBuffer stringBuffer = new StringBuffer(string);
            byte[] byArray2 = this.mac.doFinal(byArray);
            String string2 = Base64.encodeBytes(byArray2, 8);
            stringBuffer.append(this.config.getPrefix());
            stringBuffer.append(string2);
            stringBuffer.append(this.config.getSuffix());
            return stringBuffer.toString();
        }
    }

    public boolean verify(String string, String string2) {
        byte[] byArray = Base64.decode(string2);
        return this.verify(string, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String string, byte[] byArray) {
        Mac mac = this.mac;
        synchronized (mac) {
            byte[] byArray2 = SyslogUtility.getBytes(this.config, string);
            byte[] byArray3 = this.mac.doFinal(byArray2);
            return Arrays.equals(byArray3, byArray);
        }
    }
}

