/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import nxd.dao.DaoUtil;
import nxd.dao.LdapDao;
import nxd.data.AdapData;
import nxd.data.LdapData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.f;

public class AdapDao
extends LdapDao {
    @Override
    public int selectCount() {
        String string = "select count(*) from ldap where ldap_type = 1";
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f(string);
        b2.close();
        return n2;
    }

    protected AdapData a(RowSet rowSet) {
        AdapData adapData = new AdapData();
        adapData.id = rowSet.getInt("id");
        adapData.host = rowSet.getString("host");
        adapData.admin = rowSet.getString("admin");
        adapData.passwd = rowSet.getString("passwd");
        adapData.passwdNotEncoded = rowSet.getString("passwd");
        adapData.basedn = rowSet.getString("basedn");
        adapData.domain = rowSet.getString("domain");
        adapData.period = rowSet.getInt("period");
        adapData.followReferral = rowSet.str2bool("follow_referral");
        adapData.ldapType = rowSet.getInt("ldap_type");
        adapData.excludeKeyword = rowSet.getString("exclude_keyword");
        adapData.excludeEmptyGroup = rowSet.str2bool("exclude_empty_group");
        adapData.dnsIp = rowSet.getString("dns_ip");
        adapData.dnsTimeout = rowSet.getInt("dns_timeout");
        adapData.dnsLoadBalance = rowSet.str2bool("dns_load_balance");
        adapData.useSsl = rowSet.str2bool("use_ssl");
        adapData.port = rowSet.getInt("port");
        adapData.sslCertificateCn = rowSet.getString("ssl_certificate_cn");
        adapData.userFilter = rowSet.getString("user_filter");
        adapData.grpFilter = rowSet.getString("grp_filter");
        if (nxd.lib.c.a(adapData.userFilter)) {
            adapData.userFilter = "(&(objectCategory=person)(objectClass=user))";
        }
        if (nxd.lib.c.a(adapData.grpFilter)) {
            adapData.grpFilter = "(objectClass=group)";
        }
        return adapData;
    }

    @Override
    public AdapData selectOne(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from ldap where id = ? and ldap_type = ?";
        RowSet rowSet = b2.m(string, new Object[]{n2, 1});
        if (rowSet == null) {
            b2.close();
            return null;
        }
        AdapData adapData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return adapData;
    }

    @Override
    public List<LdapData> selectList() {
        String string = String.format("select * from ldap where ldap_type = %s order by id desc", 1);
        ArrayList<LdapData> arrayList = new ArrayList<LdapData>();
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private boolean a(AdapData adapData) {
        if (!f.b(adapData.host)) {
            this.d.error("AdapDao.checkParam, Invalid host IP!");
            return false;
        }
        if (nxd.lib.c.a(adapData.admin)) {
            this.d.error("AdapDao.checkParam, Admin missing!");
            return false;
        }
        if (nxd.lib.c.a(adapData.basedn)) {
            this.d.error("AdapDao.checkParam, Base DN missing!");
            return false;
        }
        return true;
    }

    public boolean insert(AdapData adapData) {
        adapData.sanitize();
        if (!this.a(adapData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into ldap(host, admin, passwd, basedn, domain, period, ldap_type, dns_ip, user_filter, grp_filter)";
        string = string + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        boolean bl = b2.d(string, new Object[]{adapData.host, adapData.admin, adapData.passwd, adapData.basedn, adapData.domain, adapData.period, 1, adapData.dnsIp, "(&(objectCategory=person)(objectClass=user))", "(objectClass=group)"});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("ldap");
        return true;
    }

    public boolean update(AdapData adapData) {
        adapData.sanitize();
        if (!this.a(adapData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update ldap set host = ?, admin = ?, passwd = ?, basedn = ?";
        string = string + ", domain = ?, period = ?, follow_referral = ?, ldap_type = ?, exclude_keyword = ?";
        string = string + ", dns_ip = ?, dns_timeout = ?, dns_load_balance = ?, use_ssl = ?, port = ?";
        string = string + ", ssl_certificate_cn = ?, user_filter = ?, grp_filter = ?, exclude_empty_group = ?";
        string = string + " where id = ?";
        boolean bl = b2.d(string, new Object[]{adapData.host, adapData.admin, adapData.passwd, adapData.basedn, adapData.domain, adapData.period, nxd.lib.c.d(adapData.followReferral), adapData.ldapType, adapData.excludeKeyword, adapData.dnsIp, adapData.dnsTimeout, nxd.lib.c.d(adapData.dnsLoadBalance), nxd.lib.c.d(adapData.useSsl), adapData.port, adapData.sslCertificateCn, adapData.userFilter, adapData.grpFilter, nxd.lib.c.d(adapData.excludeEmptyGroup), adapData.id});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("whitelist");
        this.c.b("ldap");
        return true;
    }

    @Override
    protected /* synthetic */ LdapData b(RowSet rowSet) {
        return this.a(rowSet);
    }
}

