/*
 * Decompiled with CFR 0.152.
 */
package nxd.data;

import nxd.data.FirstData;
import nxd.lib.c;

public class LdapData
extends FirstData {
    public static final int TYPE_AD = 1;
    public static final int TYPE_LD = 2;
    public static final int TYPE_AZ = 4;
    public int id = 0;
    public String host = "";
    public String admin = "";
    public String passwd = "";
    public String basedn = "";
    public String domain = "";
    public int period = 0;
    public boolean zoneTransfer = false;
    public boolean followReferral = false;
    public int ldapType = 0;
    public String passwdNotEncoded = "";
    public String excludeKeyword = "";
    public boolean useSsl = false;
    public int port = 0;
    public String sslCertificateCn = "";
    public boolean excludeEmptyGroup = true;

    @Override
    public void sanitize() {
        this.host = c.a(this.host, 255);
        this.admin = c.a(this.admin, 255);
        this.basedn = c.a(this.basedn, 255);
        this.domain = c.a(this.domain, 255);
        if (this.ldapType != 1 && this.ldapType != 2) {
            this.ldapType = 1;
        }
        this.period = this.period < 0 ? 0 : this.period;
        this.excludeKeyword = c.a(this.excludeKeyword, 2000);
        this.sslCertificateCn = c.a(this.sslCertificateCn, 255).toLowerCase();
    }

    public String getZoneTransferYn() {
        if (this.zoneTransfer) {
            return "Y";
        }
        return "N";
    }

    public String getFollowReferralYn() {
        if (this.followReferral) {
            return "Y";
        }
        return "N";
    }

    public String getLdapType() {
        if (this.ldapType == 1) {
            return "AD";
        }
        if (this.ldapType == 2) {
            return "LD";
        }
        return "";
    }

    public boolean isActiveDirectory() {
        return this.ldapType == 1;
    }

    public boolean isOpenLdap() {
        return this.ldapType == 2;
    }
}

