<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void insert(DhcpReservedIpDao dao){
	DhcpReservedIpData data = new DhcpReservedIpData();
	data.ip = paramString("ip");
	data.mac = paramString("mac");
	data.description = paramString("description");

	// Param validation.
	if(!isValidIp(data.ip)){
		errList.add(translate("Invalid IP."));
		return;
	}

	if(!ParamTest.isValidMac(data.mac)){
		errList.add(translate("Invalid MAC address."));
		return;
	}

	if(ParamTest.isDupDhcpReservedIp(data.ip, data.mac)){
		errList.add(translate("IP or MAC already exists."));
	}

	if(ParamTest.isDhcpReservedIpOutOfRange(data.ip)){
		errList.add(translate("IP is out of range."));
	}

	if(dao.insert(data)){
		succList.add(translate("Update finished."));
	}
}

//-----------------------------------------------
void delete(DhcpReservedIpDao dao){
	if(dao.delete(paramInt("id"))){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
DhcpReservedIpDao dao = new DhcpReservedIpDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item">DHCP</li>
		<li class="breadcrumb-item text-info"><%= translate("RESERVED IP")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Form -->
<div class="container-fluid">
	<div class="card bg-light m-2 expand-lg">
		<div class="card-body">
			<form action="<%= getPageName()%>" method="post">
				<input type="hidden" name="actionFlag" value="insert">

				<div class="form-group col-lg-8 text-secondary">
					<%= translate("You can reserve an IP for a specific MAC address here.")%>
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">IP</label>
					<input type="text" class="form-control" id="ip" name="ip">
				</div>
				<div class="form-group col-lg-8">
					<label class="col-form-label">MAC</label>
					<input type="text" class="form-control" id="mac" name="mac">
				</div>
				<div class="form-group col-lg-8">
					<label class="col-form-label"><%= translate("Description")%></label>
					<input type="text" class="form-control" id="description" name="description">
				</div>
				<div class="form-group col-lg-8">
					<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
					<button type="button" class="btn btn-warning" onclick="javascript:actionDeleteAll();"><%= translate("DELETE ALL")%></button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- /Form -->

<!-- List -->
<div id="listDiv" class="container-fluid" style="display: none;">
	<div class="m-2 expand-lg">
		<table id="list" class="cell-border hover" style="width:100%">
			<thead>
				<tr>
					<th>IP</th>
					<th>MAC</th>
					<th><%= translate("Description")%></th>
					<th></th>
				</tr>
			</thead>
			<tbody>
<%
List<DhcpReservedIpData> dataList = dao.selectList();
for(int i = 0; i < dataList.size(); i++){
	DhcpReservedIpData data = dataList.get(i);
%>
				<tr>
					<td><%= data.ip%></td>
					<td><%= data.mac%></td>
					<td><%= data.description%></td>
					<td>
						<i class="fa fa-trash pointer-cursor" title="<%= translate("Delete")%>" onclick="javascript:actionDelete(<%= data.id%>, '<%= data.ip%>')"></i>
					</td>
				</tr>
<%}%>
			</tbody>
		</table>
	</div>
</div>
<!-- /List -->

<!-- goForm -->
<form name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>

<script>
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"bLengthChange" : false,
		"ordering" : false,
		"info" : true,
		"initComplete": function(settings, json){
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
function actionDelete(id, ip){
	if(!confirm('<%= translate("Deleting IP")%> : ' +  ip)){
		return;
	}

	var form = document.goForm;
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
// Prevent submit again.
if(window.history.replaceState){
	window.history.replaceState(null, null, window.location.href);
}
</script>
