<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(LicenseDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	String licKey = paramString("licKey");

	if(!dao.isValidLicenseKey(licKey)){
		errList.add(translate("Invalid license key!"));
		return;
	}

	if(dao.isExpiredLicenseKey(licKey)){
		errList.add(translate("Expired license key!"));
		return;
	}

	if(dao.updateLicenseKey(licKey)){
		succList.add(translate("License has been activated."));
	}
	else{
		errList.add(translate("Couldn't activate license!"));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
LicenseDao dao = new LicenseDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
LicenseData data = dao.selectOne();

boolean gRenewFlag = false;
int remainingDays = data.getRemainingDays();
if(data.blacklistType == 5 && remainingDays <= 60){
	gRenewFlag = true;
}

if(remainingDays > 0 && remainingDays <= 30){
	String tLine = translate("License expires in %s days.");
	infoList.add(String.format(tLine, remainingDays));
}

if(remainingDays < 0){
	errList.add("License has been expired.");
}

if(demoFlag){
	data.licKey = "";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("SYSTEM")%></li>
		<li class="breadcrumb-item text-info"><%= translate("LICENSE")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<div class="card bg-light m-2 expand-lg">
		<div class="card-body">
			<form action="<%= getPageName()%>" method="post">
				<input type="hidden" name="actionFlag" value="update">
				<fieldset>
					<div class="form-row col-lg-8">
						<label class="col-form-label col-lg-2 col-sm-2"><%= translate("Type")%></label>
						<label class="col-form-label"><%= data.getType()%></label>
					</div>
					<div class="form-row col-lg-8">
						<label class="col-form-label col-lg-2 col-sm-2"><%= translate("End Date")%></label>
						<label class="col-form-label"><%= data.getEndDate()%></label>
					</div>
					<div class="form-row col-lg-8">
						<label class="col-form-label col-lg-2 col-sm-2"><%= translate("Max User")%></label>
						<label class="col-form-label"><%= data.maxUser%></label>
					</div>
					<div class="form-row col-lg-8">
						<label class="col-form-label col-lg-2 col-sm-2"><%= translate("Status")%></label>
						<label class="col-form-label"><%= translate(data.getStatus())%></label>
					</div>
					<div class="form-group col-lg-8">
						<label class="col-form-label">
							<%= translate("License Key")%>
							&nbsp;<i class="fa fa-question-circle south-east"
								title="<%= translate("When you purchase a license, you will receive a 'license.lic' file. Your license key is contained in this file.")%>"></i>
						</label>
						<input type="text" class="form-control" id="licKey" name="licKey"
							value="">
					</div>
					<div class="form-group col-lg-8" style="margin-top: 10px;">
						<button type="submit" class="btn btn-primary""><%= translate("ACTIVATE")%></button>
						<button type="button" class="btn btn-info"
							onclick="javascript:actionBuyNew(this.form);"><%= translate("BUY NEW LICENSE")%></button>
						<%if(gRenewFlag){%>
							<button type="button" class="btn btn-warning"
								onclick="javascript:actionRenewOld(this.form);"><%= translate("RENEW EXISTING LICENSE")%></button>
						<%}%>
					</div>
				</fieldset>
			</form>
		</div>
	</div>

</div>
<!-- /Main content -->

<%@include file="include/footer.jsp"%>

<script>
//-----------------------------------------------
function popupPaymentForm(url){
  var option = "width=550, height=600";
  window.open(url, "", option);
}

//-----------------------------------------------
function actionBuyNew(form){
	window.open("https://nxfilter.org/p4/license-shop/", "_blank");
}

<%if(!demoFlag && gRenewFlag){%>
	//-----------------------------------------------
	function actionRenewOld(form){
		popupPaymentForm("https://nxfilter.org/shop/jahaslist.php?renew_flag=1&lic_key=<%= data.licKey%>&lic_user=<%= data.maxUser%>");
	}
<%}%>
</script>
