<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(PolicyNxProxyDao dao){
	PolicyNxProxyData data = new PolicyNxProxyData();
	data.enableFilter = paramBoolean("enableFilter");
	data.localDns = paramString("localDns");
	data.localDomain = paramString("localDomain");

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
PolicyNxProxyDao dao = new PolicyNxProxyDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
PolicyNxProxyData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
	<legend>NXPROXY</legend>
<table class="view">

	<tr>
		<td width="200">Enable Filter</td>
		<td>
		<input type="checkbox" class="no-border" name="enableFilter"
			<%if(data.enableFilter){out.print("checked");}%>> NxProxy is a DNS (DoH) level remote filtering agent.
			</td>
	</tr>

	<tr>
		<td>
			Local Domain
			<i class="fa fa-question-circle south-east" title="This is for bypassing local domains. You can add multiple domains separated by spaces.
				<br>&nbsp;&nbsp;ex) www.nxfilter.local *.jahastech.local"></i>
		</td>
		<td>
			<textarea name="localDomain" cols="80" rows="8"><%= data.localDomain%></textarea>
		</td>
	</tr>

	<tr>
		<td>
			Local DNS Server
			<i class="fa fa-question-circle south-east" title="This is optional. NxProxy will try to find the DNS server in its network by itself.
				<br>This is for when you want to specify your own DNS server for sure."></i>
		</td>
		<td>
			<input type="text" name="localDns" value="<%= data.localDns%>" size="50"
				class="east" title="Multiple IP addresses should be separated by commas.">
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>
<!-- /view -->

<%@include file="include/footer.jsp"%>
