<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(RadiusDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	RadiusData data = new RadiusData();

    data.radiusAcctPort = paramInt("radiusAcctPort");
    data.radiusSharedSecret = paramString("radiusSharedSecret");
    data.radiusEnableLogout = paramBoolean("radiusEnableLogout");
	data.useRadius = paramBoolean("useRadius");

    data.radiusLocalDomain = paramString("radiusLocalDomain");
    data.radiusGrpId = paramInt("radiusGrpId");
    data.radiusAddNew = paramBoolean("radiusAddNew");

	// Validate and update it.
	if(dao.update(data)){
		succList.add("Data updated.");
		warnList.add("Restarting required to apply new settings.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
RadiusDao dao = new RadiusDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
RadiusData data = dao.selectOne();
List<GroupData> gGroupList = new GroupDao().selectListUserCreatedOnly();
%>
<%@include file="include/action_info.jsp"%>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
<legend>RADIUS</legend>
<table class="view">

	<tr>
		<td width="200">Accounting Port</td>
		<td><input type="text" name="radiusAcctPort" value="<%= data.radiusAcctPort%>" size="2"></td>
	</tr>

	<tr>
		<td>Shared Secret</td>
		<td><input type="text" name="radiusSharedSecret" value="<%= data.radiusSharedSecret%>" size="50"></td>
	</tr>

	<tr>
		<td>Enable Logout</td>
		<td><input type="checkbox" class="no-border"
			name="radiusEnableLogout" <%if(data.radiusEnableLogout){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Auto-register for New User
			<i class="fa fa-question-circle south-east" title="Adding new users from 802.1x Wi-Fi authentication automatically."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="radiusAddNew" <%if(data.radiusAddNew){out.print("checked");}%>>
			</td>
	</tr>

	<tr>
		<td>Default Group for New User</td>
		<td>
		<%
		out.println("<select name='radiusGrpId'>");
		out.println("<option value='0'>anon-grp");

		for(GroupData grp : gGroupList){
			if(grp.id == data.radiusGrpId){
				printf("<option value='%s' selected>%s\n", grp.id, grp.name);
			}
			else{
				printf("<option value='%s'>%s\n", grp.id, grp.name);
			}
		}

		out.println("</select>");
		%>
		</td>
	</tr>

	<tr>
		<td>
			Local Domain
			<i class="fa fa-question-circle south-east"
				title="When you recive usernames in an email form (uname@mydomain.loal) you can specify domains to remove.<br>
				At default, NxFilter removes the domain part from an email form username always.<br>
				You can add multiple local domains separated by commas."></i>
		</td>
		<td>
		<input type="text" name="radiusLocalDomain" value="<%= data.radiusLocalDomain%>" size="50"
			class="east" title="Multiple IP addresses should be separated by commas.">
		</td>
	</tr>

	<tr>
		<td>Use RADIUS</td>
		<td><input type="checkbox" class="no-border"
			name="useRadius" <%if(data.useRadius){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td></td>
		<td>
<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>

<%@include file="include/footer.jsp"%>
