<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void quotaReset(UserTestDao dao){
	if(dao.quotaReset(paramString("name"))){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void bwdtReset(UserTestDao dao){
	if(dao.bwdtReset(paramString("name"))){
		succList.add("Data updated.");
	}
}

//-----------------------------------------------
void loginSessionReset(UserTestDao dao){
	if(dao.loginSessionReset(paramString("name"))){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
UserTestDao dao = new UserTestDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("quotaReset")){
	quotaReset(dao);
}
if(actionFlag.equals("bwdtReset")){
	bwdtReset(dao);
}
if(actionFlag.equals("loginSessionReset")){
	loginSessionReset(dao);
}

// Global.
UserTestData data = dao.test(paramString("name"));
%>
<script type="text/javascript">
//-----------------------------------------------
function actionQuotaResetUser(form){
	form.actionFlag.value = "quotaReset";
	form.submit();
}

//-----------------------------------------------
function actionBandwidthResetUser(form){
	form.actionFlag.value = "bwdtReset";
	form.submit();
}

//-----------------------------------------------
function actionLoginSessionResetUser(form){
	form.actionFlag.value = "loginSessionReset";
	form.submit();
}
</script>
<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="quotaReset">
<input type="hidden" name="name" value="<%= data.name%>">

<!--  -->
<fieldset>
	<legend>USER</legend>
<table width="100%" class="view">

	<tr height="25">
		<td width="200">Name</td>
		<td>
			<%= data.name%>
		</td>
	</tr>

	<tr height="25">
		<td>Group</td>
		<td>
			<%= data.groupName%>
		</td>
	</tr>

	<tr height="25">
		<td>User Policy</td>
		<td>
			<%= data.policyName%>
		</td>
	</tr>

	<tr height="25">
		<td>Applied Policy</td>
		<td>
			<%= data.appliedPolicyName%>
		</td>
	</tr>

	<tr height="25">
		<td>Free-time</td>
		<td>
			<%= data.isFreeTime ? "Yes" : "No"%>
		</td>
	</tr>

	<tr height="25">
		<td>Quota</td>
		<td>
			<%= data.quotaConsumed%> / <%= data.quotaLimit%> minutes
			<input type="button" value="RESET" onclick="javascript:actionQuotaResetUser(this.form)">
		</td>
	</tr>

	<tr height="25">
		<td>Bandwidth</td>
		<td>
			<%= data.bandwidthConsumed%> / <%= data.bandwidthLimit%> MB
			<input type="button" value="RESET" onclick="javascript:actionBandwidthResetUser(this.form)">
		</td>
	</tr>

	<tr height="25">
		<td>Login Session TTL</td>
		<td>
			<%= data.loginSessionTtl%> seconds
			<input type="button" value="RESET" onclick="javascript:actionLoginSessionResetUser(this.form)">
		</td>
	</tr>

</table>
</fieldset>

<!-- /view -->

<%@include file="include/footer.jsp"%>
