/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import nxd.dao.ClusterDao;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.data.DhcpSetupData;
import nxd.e.e;
import nxd.e.f;
import nxd.e.h;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.o.v;

public class DhcpSetupDao
extends FirstDao {
    public DhcpSetupData selectOne() {
        DhcpSetupData dhcpSetupData = new DhcpSetupData();
        f f2 = f.a();
        dhcpSetupData.listenIp = f2.b;
        dhcpSetupData.startIp = f2.c;
        dhcpSetupData.endIp = f2.d;
        dhcpSetupData.subnetMask = f2.e;
        dhcpSetupData.gatewayIp = f2.f;
        dhcpSetupData.dnsIp = nxd.lib.c.a(f2.g, ",");
        dhcpSetupData.defaultDomain = f2.h;
        dhcpSetupData.leaseSeconds = f2.i;
        dhcpSetupData.ntpIp = nxd.lib.c.a(f2.j, ",");
        dhcpSetupData.tftpServer = f2.k;
        dhcpSetupData.bootFile = f2.l;
        dhcpSetupData.wpadUrl = f2.m;
        dhcpSetupData.maxPoolSize = f2.n;
        dhcpSetupData.runDhcp = f2.o;
        dhcpSetupData.preventConflict = f2.q;
        String string = "select * from dhcp_backup";
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.m(string);){
            dhcpSetupData.bsListenIp = rowSet.getString("listen_ip");
            dhcpSetupData.bsStartIp = rowSet.getString("start_ip");
            dhcpSetupData.bsEndIp = rowSet.getString("end_ip");
        }
        return dhcpSetupData;
    }

    public boolean needToRestart(DhcpSetupData dhcpSetupData) {
        f f2 = f.a();
        return !f2.b.equals(dhcpSetupData.listenIp) || f2.o != dhcpSetupData.runDhcp || f2.q != dhcpSetupData.preventConflict;
    }

    public boolean needToReload(DhcpSetupData dhcpSetupData) {
        f f2 = f.a();
        return !f2.c.equals(dhcpSetupData.startIp) || !f2.d.equals(dhcpSetupData.endIp) || f2.n != dhcpSetupData.maxPoolSize;
    }

    public static boolean isOverlappedIpRange(String string, String string2, String string3, String string4) {
        return f.a(string, string2, string3, string4);
    }

    private boolean a(DhcpSetupData dhcpSetupData) {
        if (!nxd.lib.f.b(dhcpSetupData.listenIp)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid listen IP.");
            return false;
        }
        if (!nxd.lib.f.b(dhcpSetupData.startIp)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid start IP.");
            return false;
        }
        if (!nxd.lib.f.b(dhcpSetupData.endIp)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid end IP.");
            return false;
        }
        if (!nxd.lib.f.b(dhcpSetupData.subnetMask)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid subnet mask.");
            return false;
        }
        if (!nxd.lib.f.b(dhcpSetupData.gatewayIp)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid gateway IP.");
            return false;
        }
        if (nxd.lib.c.b(dhcpSetupData.tftpServer) && !nxd.lib.f.b(dhcpSetupData.tftpServer)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid TFTP server IP.");
            return false;
        }
        try {
            if (!nxd.lib.f.a(dhcpSetupData.startIp, dhcpSetupData.endIp, dhcpSetupData.subnetMask)) {
                this.d.error("DhcpSetupDao.checkParam, Start and end IPs must be in the same subnet defined by subnetMask.");
            }
            if (!nxd.lib.f.a(dhcpSetupData.gatewayIp, dhcpSetupData.startIp, dhcpSetupData.subnetMask)) {
                this.d.error("DhcpSetupDao.checkParam, Gateway IP must be in the same subnet as the start IP.");
            }
        }
        catch (Exception exception) {
            this.d.error("DhcpSetupDao.checkParam, " + exception.toString());
        }
        if (nxd.lib.f.k(dhcpSetupData.startIp) > nxd.lib.f.k(dhcpSetupData.endIp)) {
            this.d.error("DhcpSetupDao.checkParam, startIp must not be greater than endIp.");
        }
        if (nxd.lib.c.b(dhcpSetupData.bsListenIp) && !nxd.lib.f.b(dhcpSetupData.bsListenIp)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid backup server listen IP.");
            return false;
        }
        if (nxd.lib.c.b(dhcpSetupData.bsStartIp) && !nxd.lib.f.b(dhcpSetupData.bsStartIp)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid backup server start IP.");
            return false;
        }
        if (nxd.lib.c.b(dhcpSetupData.bsEndIp) && !nxd.lib.f.b(dhcpSetupData.bsEndIp)) {
            this.d.error("DhcpSetupDao.checkParam, Invalid backup server end IP.");
            return false;
        }
        return true;
    }

    public void updateDhcpBackup(DhcpSetupData dhcpSetupData) {
        if (!(nxd.lib.f.b(dhcpSetupData.bsListenIp) && nxd.lib.f.b(dhcpSetupData.bsStartIp) && nxd.lib.f.b(dhcpSetupData.bsEndIp))) {
            return;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            v v2 = new v("dhcp_backup");
            v2.a("listen_ip", dhcpSetupData.bsListenIp);
            v2.a("start_ip", dhcpSetupData.bsStartIp);
            v2.a("end_ip", dhcpSetupData.bsEndIp);
            b2.b(v2.a(), v2.b());
        }
    }

    public boolean update(DhcpSetupData dhcpSetupData) {
        dhcpSetupData.sanitize();
        if (!this.a(dhcpSetupData)) {
            return false;
        }
        boolean bl = false;
        if (this.needToReload(dhcpSetupData)) {
            bl = true;
        }
        f f2 = f.a();
        f2.b = dhcpSetupData.listenIp;
        f2.c = dhcpSetupData.startIp;
        f2.d = dhcpSetupData.endIp;
        f2.e = dhcpSetupData.subnetMask;
        f2.f = dhcpSetupData.gatewayIp;
        f2.g = dhcpSetupData.dnsIp.split(",");
        f2.h = dhcpSetupData.defaultDomain;
        f2.i = dhcpSetupData.leaseSeconds;
        f2.j = dhcpSetupData.ntpIp.split(",");
        f2.k = dhcpSetupData.tftpServer;
        f2.l = dhcpSetupData.bootFile;
        f2.m = dhcpSetupData.wpadUrl;
        f2.n = dhcpSetupData.maxPoolSize;
        f2.o = dhcpSetupData.runDhcp;
        f2.q = dhcpSetupData.preventConflict;
        f2.e();
        f2.d();
        f2.b();
        this.updateDhcpBackup(dhcpSetupData);
        this.d.info("DhcpSetupDao.update, " + f2.toString());
        if (bl) {
            this.d.info("DhcpSetupDao.update, We initialize IpPool again.");
            try (b b2 = DaoUtil.getDbConfig();){
                String string = "delete from dhcp_ip_pool where ip_numeric < ? or ip_numeric > ?";
                b2.b(string, new Object[]{f2.r, f2.s});
            }
            h.a().b();
        }
        if (nxd.lib.c.b(dhcpSetupData.bsListenIp)) {
            this.c.b("dhcp_backup_reload");
        }
        return true;
    }

    public void restartServer() {
        if (!new ClusterDao().isSlave()) {
            e e2 = e.a();
            this.d.info("DhcpSetupDao.update, Stopping DHCP server.");
            e2.c();
            this.d.info("DhcpSetupDao.update, Sarting DHCP server.");
            e2.b();
        }
    }

    public void stopServer() {
        if (!new ClusterDao().isSlave()) {
            e e2 = e.a();
            this.d.info("DhcpSetupDao.update, Stopping DHCP server.");
            e2.c();
        }
    }

    public boolean isStarted() {
        return e.a().a;
    }
}

