/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.SubAdminData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.o.p;
import org.apache.commons.codec.digest.DigestUtils;

public class SubAdminDao
extends FirstDao {
    private SubAdminData a(RowSet rowSet) {
        SubAdminData subAdminData = new SubAdminData();
        subAdminData.id = rowSet.getInt("id");
        subAdminData.name = rowSet.getString("name");
        subAdminData.passwd = rowSet.getString("passwd");
        subAdminData.description = rowSet.getString("description");
        subAdminData.permDns = rowSet.getBoolean("perm_dns");
        subAdminData.permDhcp = rowSet.getBoolean("perm_dhcp");
        subAdminData.permUser = rowSet.getBoolean("perm_user");
        subAdminData.permPolicy = rowSet.getBoolean("perm_policy");
        subAdminData.permCategory = rowSet.getBoolean("perm_category");
        subAdminData.permClassifier = rowSet.getBoolean("perm_classifier");
        subAdminData.permWhitelist = rowSet.getBoolean("perm_whitelist");
        subAdminData.permLogging = rowSet.getBoolean("perm_logging");
        subAdminData.permReport = rowSet.getBoolean("perm_report");
        subAdminData.permDashboard = rowSet.getBoolean("perm_dashboard");
        subAdminData.permSystem = rowSet.getBoolean("perm_system");
        return subAdminData;
    }

    public List<SubAdminData> selectList() {
        ArrayList<SubAdminData> arrayList = new ArrayList<SubAdminData>();
        String string = "select * from sub_admin order by lower(name)";
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public boolean delete(int n2) {
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from sub_admin where id = ?";
            b2.b(string, new Object[]{n2});
        }
        catch (Exception exception) {
            this.d.error("DB error!");
            return false;
        }
        return true;
    }

    private boolean a(SubAdminData subAdminData) {
        if (!nxd.lib.c.a(subAdminData.passwd) && !nxd.lib.c.g(subAdminData.passwd)) {
            if (!ParamTest.isValidPasswdLen(subAdminData.passwd)) {
                this.d.error("SubAdminDao.checkParam, {}", (Object)ParamTest.ERR_PASSWD_LEN);
                return false;
            }
            if (!ParamTest.isValidPasswdChar(subAdminData.passwd)) {
                this.d.error("SubAdminDao.checkParam, {}", (Object)"Only ASCII character allowed in password.");
                return false;
            }
        }
        return true;
    }

    private boolean b(SubAdminData subAdminData) {
        this.a(subAdminData);
        if (!ParamTest.isValidNameLen(subAdminData.name)) {
            this.d.error("SubAdminDao.checkParamInsert, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidUsernameChar(subAdminData.name)) {
            this.d.error("SubAdminDao.checkParamInsert, {}", (Object)"Only alphabet, number, [-_] allowed in name.");
            return false;
        }
        if (ParamTest.isDupSubAdmin(subAdminData.name)) {
            this.d.error("SubAdminDao.checkParamInsert, admin already exists!");
            return false;
        }
        return true;
    }

    private boolean c(SubAdminData subAdminData) {
        return this.a(subAdminData);
    }

    public boolean insert(SubAdminData subAdminData) {
        subAdminData.sanitize();
        if (!this.b(subAdminData)) {
            return false;
        }
        subAdminData.passwd = p.a(16);
        subAdminData.passwd = DigestUtils.shaHex((String)subAdminData.passwd);
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into sub_admin(name, passwd, description)";
        string = string + " values(?, ?, ?)";
        boolean bl = b2.d(string, new Object[]{subAdminData.name, subAdminData.passwd, subAdminData.description});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        return true;
    }

    private SubAdminData a(String string, Object[] objectArray) {
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.m(string, objectArray);
        if (rowSet == null) {
            b2.close();
            return null;
        }
        SubAdminData subAdminData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return subAdminData;
    }

    public SubAdminData selectOne(int n2) {
        String string = "select * from sub_admin where id = ?";
        return this.a(string, new Object[]{n2});
    }

    public SubAdminData selectOneByName(String string) {
        String string2 = "select * from sub_admin where name = ?";
        return this.a(string2, new Object[]{string});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(SubAdminData subAdminData) {
        subAdminData.sanitize();
        if (!this.c(subAdminData)) {
            return false;
        }
        if (!nxd.lib.c.a(subAdminData.passwd) && !nxd.lib.c.g(subAdminData.passwd)) {
            subAdminData.passwd = DigestUtils.shaHex((String)subAdminData.passwd);
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update sub_admin set passwd = ?, description = ?";
        string = string + ", perm_dns = ?, perm_dhcp = ?, perm_user = ?, perm_policy = ?, perm_category = ?";
        string = string + ", perm_classifier = ?, perm_whitelist = ?, perm_logging = ?, perm_report = ?";
        string = string + ", perm_dashboard = ?, perm_system = ?";
        string = string + " where id = ?";
        try {
            b2.c(string, new Object[]{subAdminData.passwd, subAdminData.description, subAdminData.permDns, subAdminData.permDhcp, subAdminData.permUser, subAdminData.permPolicy, subAdminData.permCategory, subAdminData.permClassifier, subAdminData.permWhitelist, subAdminData.permLogging, subAdminData.permReport, subAdminData.permDashboard, subAdminData.permSystem, subAdminData.id});
        }
        catch (Exception exception) {
            this.d.error("DB error! - " + exception.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            b2.close();
        }
        return true;
    }

    private boolean a(String string) {
        if (!ParamTest.isValidPasswdLen(string)) {
            this.d.error("SubAdmin.checkPasswd, {}", (Object)ParamTest.ERR_PASSWD_LEN);
            return false;
        }
        if (!ParamTest.isValidPasswdChar(string)) {
            this.d.error("SubAdmin.checkPasswd, {}", (Object)"Only ASCII character allowed in password.");
            return false;
        }
        return true;
    }

    public boolean updateAdminPw(String string, int n2) {
        if (!this.a(string)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string2 = "update sub_admin set passwd = ? where id = ?";
        boolean bl = b2.d(string2, new Object[]{DigestUtils.shaHex((String)string), n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("admin");
        return true;
    }

    public boolean isAdminPw(String string, int n2) {
        SubAdminData subAdminData = this.selectOne(n2);
        return DigestUtils.shaHex((String)string).equals(subAdminData.passwd);
    }
}

