/*
 * Decompiled with CFR 0.152.
 */
package nxd.data;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nxd.data.FirstData;
import nxd.data.PolicyData;
import nxd.lib.c;
import nxd.lib.d;
import nxd.o.j;

public class WhitelistData
extends FirstData {
    public int id = 0;
    public String domain = "";
    public String keyword = "";
    public String description = "";
    public boolean bypassAuth = false;
    public boolean bypassFilter = false;
    public boolean bypassLog = false;
    public boolean adminBlock = false;
    public boolean dropPacket = false;
    public Map<Integer, PolicyData> appliedPolicyMap = new HashMap<Integer, PolicyData>();
    public String[] appliedPolicyArr = new String[0];
    public String uname = "";
    public int type = 0;
    public int ctime = 0;
    public int ttl = 0;

    @Override
    public void sanitize() {
        this.domain = c.a(this.domain, 255).toLowerCase();
        this.keyword = c.a(this.keyword, 64).toLowerCase();
        this.description = c.a(this.description, 100);
        if (this.adminBlock) {
            this.bypassFilter = false;
        }
        this.ttl = c.a(this.ttl, 0, 720);
    }

    public String getFlagLine() {
        String string = "";
        if (this.bypassAuth) {
            string = string + ", bypass_auth";
        }
        if (this.bypassFilter) {
            string = string + ", bypass_filter";
        }
        if (this.bypassLog) {
            string = string + ", bypass_log";
        }
        if (this.adminBlock) {
            string = string + ", admin_block";
        }
        if (this.dropPacket) {
            string = string + ", drop_packet";
        }
        string = string.replaceFirst("^, ", "");
        return string;
    }

    public String getAppliedPolicyLine() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (PolicyData policyData : this.appliedPolicyMap.values()) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(policyData.name);
            ++n2;
        }
        Object object = stringBuilder.toString().replaceFirst("^, ", "");
        if (((String)object).length() == 0) {
            object = "Global";
        }
        return object;
    }

    public boolean isAppliedPolicy(int n2) {
        return this.appliedPolicyMap.containsKey(n2);
    }

    public String getExpireTime() {
        if (this.ctime == 0 || this.ttl == 0) {
            return "Permanent";
        }
        Date date = d.a(this.ctime + this.ttl * 3600);
        String string = d.a("yyyyMMddHHmm", date);
        return j.b(string);
    }

    public boolean isExpired() {
        return this.ctime + this.ttl * 3600 < d.a();
    }

    public String toString() {
        return "WhitelistData{id=" + this.id + ", domain=" + this.domain + ", keyword=" + this.keyword + ", description=" + this.description + ", bypassAuth=" + this.bypassAuth + ", bypassFilter=" + this.bypassFilter + ", bypassLog=" + this.bypassLog + ", adminBlock=" + this.adminBlock + ", dropPacket=" + this.dropPacket + ", appliedPolicyArr=" + String.join((CharSequence)",", this.appliedPolicyArr) + ", uname=" + this.uname + ", type=" + this.type + ", ctime=" + this.ctime + ", ttl=" + this.ttl + '}';
    }
}

