<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
DhcpLogDao dao = new DhcpLogDao();
dao.limit = paramInt("limit", 1000);

// Set filtering option.
dao.stime = paramString("stime");
dao.etime = paramString("etime");

dao.mac = paramString("mac");
dao.srcIp = paramString("srcIp");
dao.hostname = paramString("hostname");
dao.leaseIp = paramString("leaseIp");

if(isNotEmpty(dao.srcIp) && !isValidIp(dao.srcIp)){
	errList.add(translate("Invalid source IP."));
}

if(isNotEmpty(dao.leaseIp) && !isValidIp(dao.leaseIp)){
	errList.add(translate("Invalid lease IP."));
}

// Active tab.
String tabActive0 = "";
String tabActive1 = "";

String showActive0 = "";
String showActive1 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive0 = " active";
	showActive0 = " show active";
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("LOGGING")%></li>
		<li class="breadcrumb-item text-info"><%= translate("DHCP LOG")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Tab -->
	<div>
		<ul class="nav nav-tabs" style="margin-left:10px; margin-right:10px;">
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(0);">
				<a class="nav-link<%= tabActive0%>" data-toggle="tab" href="#tab0"><%= translate("LIST")%></a>
			</li>
			<li class="nav-item" onclick="javascript:$('#tabIdx').val(1);">
				<a class="nav-link<%= tabActive1%>" data-toggle="tab" href="#tab1"><%= translate("SEARCH OPTIONS")%></a>
			</li>
		</ul>
	</div>
	<!-- Tab -->

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" name="actionFlag" value="search">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">

		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- List -->
			<div class="tab-pane <%= showActive0%>" id="tab0">
				<div id="loadingDiv" class="container-fluid" style="display: block;">
					<table class="cell-border hover" style="width: 100%">
						<tr height="500">
							<td width="100%" align="center" valign="center">
								<img src="img/loading.gif?<%= new Random().nextInt(10000)%>">
							</td>
						<tr>
					</table>
				</div>
				<div id="listDiv" class="container-fluid" style="display: none;">
					<table id="list" class="cell-border hover" style="width: 100%">
						<thead>
							<tr>
								<th></th>
								<th><%= translate("Time")%></th>
								<th><%= translate("Type")%></th>
								<th><%= translate("MAC")%></th>
								<th><%= translate("Source IP")%></th>
								<th><%= translate("Hostname")%></th>
								<th><%= translate("Lease IP")%></th>
							</tr>
						</thead>
						<tbody>
<%
List<DhcpLogData> dataList = dao.selectList();
for(int i = 0; i < dataList.size(); i++){
	DhcpLogData data = dataList.get(i);
%>
							<tr>
								<td><%= data.ctime%></td>
								<td><%= data.getCtime()%></td>
								<td><%= data.getType()%></td>
								<td><%= data.mac%></td>
								<td><%= data.srcIp%></td>
								<td><%= data.hostname%></td>
								<td><%= data.leaseIp%></td>
							</tr>
<%}%>
						</tbody>
					</table>
				</div>
			</div>
			<!-- /List -->

			<!-- Search options -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Time")%></label>
								<div class="form-row" style="margin-left: 2px;">
									<input type="text" class="form-control col-lg-5 col-md-5" id="stime" name="stime" value="<%= dao.getStime()%>">&nbsp;~&nbsp;
									<input type="text" class="form-control col-lg-5 col-md-5" id="etime" name="etime" value="<%= dao.getEtime()%>">
								</div>
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("MAC")%></label>
								<input type="text" class="form-control" id="mac" name="mac" value="<%= dao.mac%>">
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Source IP")%></label>
								<input type="text" class="form-control" id="srcIp" name="srcIp" value="<%= dao.srcIp%>">
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Hostname")%></label>
								<input type="text" class="form-control" id="hostname" name="hostname" value="<%= dao.hostname%>">
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label"><%= translate("Lease IP")%></label>
								<input type="text" class="form-control" id="leaseIp" name="leaseIp" value="<%= dao.leaseIp%>">
							</div>
							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Search options -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<%@include file="include/footer.jsp"%>

<script>
//-----------------------------------------------
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 50,
		"lengthMenu": [[50, 100, 200], [50, 100, 200]],
		"bLengthChange" : true,
		"aaSorting": [[0, "desc"]],
		"columnDefs": [{
				"targets": 0,
				"visible": false,
				"searchable": false,
		}],
		"initComplete": function(settings, json){
			$("#loadingDiv").hide();
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
var dateToDisable = new Date();

//-----------------------------------------------
jQuery("#stime").datetimepicker({
	format: "<%= getGuiDateFormatForPicker()%> H:i",
	step: 1,
	beforeShowDay: function(date) {
		if (date.getTime() > dateToDisable.getTime()) {
			return [false, ""]
		}

		return [true, ""];
	}
});

//-----------------------------------------------
jQuery("#etime").datetimepicker({
	format: "<%= getGuiDateFormatForPicker()%> H:i",
	step: 1,
	beforeShowDay: function(date) {
		if (date.getTime() > dateToDisable.getTime()) {
			return [false, ""]
		}

		return [true, ""];
	}
});
</script>
