<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
boolean checkParam(AlertData data){
	if (isNotEmpty(data.adminEmail) && !isValidEmail(data.adminEmail)) {
		errList.add("Invalid email.");
		return false;
	}

	if (data.period > 0 && (isEmpty(data.adminEmail) || isEmpty(data.smtpHost))) {
		errList.add("Email alert option requires admin email and SMTP host.");
		return false;
	}

	return true;
}

//-----------------------------------------------
boolean update(AlertDao dao){
	AlertData oldData = dao.selectOne();
	AlertData data = new AlertData();

	data.adminEmail = paramString("adminEmail");
	data.adminCc = paramString("adminCc");
	data.smtpHost = paramString("smtpHost");
	data.smtpPort = paramInt("smtpPort");
	data.smtpEncType = paramInt("smtpEncType");
	data.smtpUser = paramString("smtpUser");
	data.smtpPasswd = paramString("smtpPasswd");
	data.period = paramInt("period");

	data.alertCategoryArr = paramArray("alertCategoryArr");

	// Validate and update it.
	if(checkParam(data) && dao.update(data)){
		succList.add("Data updated.");

		if(!oldData.adminEmail.equals(data.adminEmail)
			|| !oldData.smtpHost.equals(data.smtpHost)
			|| oldData.smtpEncType != data.smtpEncType
			|| oldData.smtpPort != data.smtpPort
			|| !oldData.smtpUser.equals(data.smtpUser)
			|| !oldData.smtpPasswd.equals(data.smtpPasswd)
		){
			warnList.add("Restart is required to apply new settings.");
		}
		return false;
	}
	return true;
}

//-----------------------------------------------
void test(AlertDao dao){
	try{
		dao.test();
		succList.add("Test email has been sent.");
	}
	catch(Exception e){
		errList.add(e.toString());
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
AlertDao dao = new AlertDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("test")){
	test(dao);
}

// Global.
AlertData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionTest(form){
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "test";
	form.submit();
}
</script>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
<legend>ALERT</legend>
<table width="100%" class="view">

	<tr>
		<td width="200">Admin Email</td>
		<td><input type="text" name="adminEmail" value="<%= data.adminEmail%>" size="50"></td>
	</tr>

	<tr>
		<td>
			CC Recipients
			<i class="fa fa-question-circle south-east" title="'CC Recipients' is only for access violation emails.<br>
				Not for system failure or license related emails.<br>
				You can add multiple email addresses separated by semicolons."></i>
		</td>
		<td>
			<input type="text" name="adminCc" value="<%= data.adminCc%>" size="50">
		</td>
	</tr>

	<tr>
		<td>SMTP Host</td>
		<td><input type="text" name="smtpHost" value="<%= data.smtpHost%>" size="50"></td>
	</tr>

	<tr>
		<td>SMTP Port</td>
		<td><input type="text" name="smtpPort" value="<%= data.smtpPort%>" size="2"></td>
	</tr>

	<tr>
		<td>SSL/TLS</td>
		<td>
			<input type="radio" class="no-border" name="smtpEncType" value="0" <%if(data.smtpEncType == 0){out.print("checked");}%>> None
			<input type="radio" class="no-border" name="smtpEncType" value="1" <%if(data.smtpEncType == 1){out.print("checked");}%>> SSL
			<input type="radio" class="no-border" name="smtpEncType" value="2" <%if(data.smtpEncType == 2){out.print("checked");}%>> STARTTLS
		</td>
	</tr>

	<tr>
		<td>SMTP User</td>
		<td><input type="text" name="smtpUser" value="<%= data.smtpUser%>" size="50"></td>
	</tr>

	<tr>
		<td>SMTP Password</td>
		<td><input type="password" name="smtpPasswd" value="<%= data.smtpPasswd%>" size="50"></td>
	</tr>

	<tr>
		<td>
			Alert Period
			<i class="fa fa-question-circle north-east" title="This option is for access violation emails only. You will get the alert emails for<br>
				system failures and license related problems regardless of this option."></i>
		</td>
		<td>
<select name="period">
<%
Map<Integer, String> periodMap = getAlertPeriodMap();
for(Map.Entry<Integer, String> entry : periodMap.entrySet()){
	Integer key = entry.getKey();
	String val = entry.getValue();

	if(key == data.period){
		printf("<option value='%s' selected>%s", key, val);
	}
	else{
		printf("<option value='%s'>%s", key, val);
	}
}
%>
</select>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="TEST" onclick="javascript:actionTest(this.form);"
				class="south-east" title="Test email will be sent to your admin email address.">
		</td>
	</tr>

</table>
</fieldset>

<fieldset>
<legend>ALERT CATEGORIES</legend>
<table width="100%" class="view">

	<tr>
		<td colspan="2">
<div style="line-height:20px;">
This is for when you block domains by categories in a policy. Blocking by other means will not be affected.
</div>
		</td>
	</tr>

	<tr>
		<td colspan="2">

<%
for(int i = 0; i < data.alertCategoryList.size(); i++){
	CategoryData cd = data.alertCategoryList.get(i);

	String chkLine = "";
	if(cd.checkFlag){
		chkLine = "checked";
	}

	if(i > 0 && i % 5 == 0){
		out.println("<br>");
	}
%>
			<span class="category-item">
				<input type="checkbox" class="no-border"
					name="alertCategoryArr" value="<%= cd.id%>" <%= chkLine%>><%= cd.name%>
			</span>
<%}%>

		</td>
	</tr>

	<tr>
		<td width="200"></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
			<input type="button" value="TOGGLE-ALL" onclick="javascript:checkboxToggleAll3('alertCategoryArr');"><br>
		</td>
	</tr>

</table>
</fieldset>

</form>

<%@include file="include/footer.jsp"%>
