<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(LdapDao dao){
	LdapData data = new LdapData();
	data.id = paramInt("id");
	data.host = paramString("host");
	data.admin = paramString("admin");
	data.passwd = paramString("passwd");
	data.basedn = paramString("basedn");
	data.ldapType = LdapData.TYPE_LD;
	data.period = paramInt("period");
	data.excludeKeyword = paramString("excludeKeyword");

	data.useSsl = paramBoolean("useSsl");
    data.port = paramInt("port");
	data.sslCertificateCn = paramString("sslCertificateCn");

	// Param validation.
	if (!isValidIp(data.host)) {
		errList.add("Invalid host IP.");
		return;
	}

	if (isEmpty(data.admin)) {
		errList.add("Admin missing.");
		return;
	}

	if (isEmpty(data.basedn)) {
		errList.add("Base DN missing.");
		return;
	}

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%@include file="include/action_info.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Check refresh without id.
if(!checkEditId("user,ldap.jsp")){
	return;
}

// Create data access object.
LdapDao dao = new LdapDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
LdapData data = dao.selectOne(paramInt("id"));
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function setDefaultPort(form){
	var port = form.port.value;

	if(form.useSsl.checked && port == 389){
		form.port.value = 636;
	}

	if(!form.useSsl.checked && port == 636){
		form.port.value = 389;
	}

	if(!form.useSsl.checked){
		form.sslCertificateCn.value = ""
	}
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">
<input type="hidden" name="id" value="<%= data.id%>">

<fieldset>
<legend>OpenLDAP</legend>
<table class="view">

	<tr>
		<td width="200">Host</td>
		<td><input type="text" name="host" size="50" value="<%= data.host%>"></td>
	</tr>

	<tr>
		<td>Port</td>
		<td><input type="text" name="port" size="2" maxlength="5" value="<%= data.port%>"></td>
	</tr>

	<tr>
		<td>Use SSL</td>
		<td>
		<input type="checkbox" name="useSsl" <%if(data.useSsl){out.print("checked");}%>
			onclick="javascript:setDefaultPort(this.form);">
		</td>
	</tr>

	<tr>
		<td>
			SSL Certificate CN
			<i class="fa fa-question-circle south-east" title="When you use your own certificate for LDAPS protocol."></i>
		</td>
		<td>
		<input type="text" name="sslCertificateCn" size="50" value="<%= data.sslCertificateCn%>">
		</td>
	</tr>

	<tr>
		<td>Admin</td>
		<td><input type="text" name="admin" size="50" value="<%= data.admin%>"></td>
	</tr>

	<tr>
		<td>Password</td>
		<td><input type="password" name="passwd" size="50" value="<%= data.passwd%>"></td>
	</tr>

	<tr>
		<td>Base DN</td>
		<td><input type="text" name="basedn" size="50" value="<%= data.basedn%>"></td>
	</tr>

	<tr>
		<td>Auto-sync</td>
		<td>
<select name="period">
<%
Map<Integer, String> periodMap = getLdapPeriodMap();
for(Map.Entry<Integer, String> entry : periodMap.entrySet()){
	Integer key = entry.getKey();
	String val = entry.getValue();

	if(key == data.period){
		printf("<option value='%s' selected>%s", key, val);
	}
	else{
		printf("<option value='%s'>%s", key, val);
	}
}
%>
</select>
		</td>
	</tr>

	<tr>
		<td>
			Exclude Keyword
			<i class="fa fa-question-circle south-east" title="To exclude some users or groups from LDAP importation by keyword matching.
				<br>Multiple keywords should be separated by spaces. For a keyword having space, use double quotes.
				<br>For exact matching, use square brackets.
				<br>&nbsp;&nbsp;ex) support devel [DHCP Users] &quot;main Co&quot; john"></i>
		</td>
		<td>
			<textarea name="excludeKeyword" cols="80" rows="6"><%= data.excludeKeyword%></textarea>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>
<!-- view -->

<%@include file="include/footer.jsp"%>
