/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.backlog.printstream;

import java.io.PrintStream;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;

public class PrintStreamSyslogBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected PrintStream printStream = null;
    protected boolean appendLinefeed = false;

    public PrintStreamSyslogBackLogHandler(PrintStream printStream) {
        this.printStream = printStream;
        this.initialize();
    }

    public PrintStreamSyslogBackLogHandler(PrintStream printStream, boolean bl) {
        this.printStream = printStream;
        this.appendLinefeed = bl;
        this.initialize();
    }

    public PrintStreamSyslogBackLogHandler(PrintStream printStream, boolean bl, boolean bl2) {
        this.printStream = printStream;
        this.appendLinefeed = bl;
        this.appendReason = bl2;
        this.initialize();
    }

    public void initialize() throws SyslogRuntimeException {
        if (this.printStream == null) {
            throw new SyslogRuntimeException("PrintStream cannot be null");
        }
    }

    public void down(SyslogIF syslogIF, String string) {
        this.printStream.println(syslogIF.getProtocol() + ": DOWN" + (string != null && !"".equals(string.trim()) ? " (" + string + ")" : ""));
    }

    public void up(SyslogIF syslogIF) {
        this.printStream.println(syslogIF.getProtocol() + ": UP");
    }

    public void log(SyslogIF syslogIF, int n, String string, String string2) {
        String string3 = this.combine(syslogIF, n, string, string2);
        if (this.appendLinefeed) {
            this.printStream.println(string3);
        } else {
            this.printStream.print(string3);
        }
    }
}

