/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.event;

import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class SyslogServerEvent
implements SyslogServerEventIF {
    private static final long serialVersionUID = 6136043067089899962L;
    public static final String DATE_FORMAT = "MMM dd HH:mm:ss yyyy";
    protected String charSet = "UTF-8";
    protected String rawString = null;
    protected byte[] rawBytes = null;
    protected int rawLength = -1;
    protected Date date = null;
    protected int level = -1;
    protected int facility = -1;
    protected String host = null;
    protected boolean isHostStrippedFromMessage = false;
    protected String message = null;
    protected InetAddress inetAddress = null;

    protected SyslogServerEvent() {
    }

    public SyslogServerEvent(String string, InetAddress inetAddress) {
        this.initialize(string, inetAddress);
        this.parse();
    }

    public SyslogServerEvent(byte[] byArray, int n, InetAddress inetAddress) {
        this.initialize(byArray, n, inetAddress);
        this.parse();
    }

    protected void initialize(String string, InetAddress inetAddress) {
        this.rawString = string;
        this.rawLength = string.length();
        this.inetAddress = inetAddress;
        this.message = string;
    }

    protected void initialize(byte[] byArray, int n, InetAddress inetAddress) {
        this.rawBytes = byArray;
        this.rawLength = n;
        this.inetAddress = inetAddress;
    }

    protected void parseHost() {
        int n = this.message.indexOf(32);
        if (n > -1) {
            String string = null;
            String string2 = null;
            String string3 = this.message.substring(0, n).trim();
            if (string3.equalsIgnoreCase(string = this.inetAddress.getHostAddress())) {
                this.host = string;
                this.message = this.message.substring(n + 1);
                this.isHostStrippedFromMessage = true;
            }
            if (this.host == null && !(string2 = this.inetAddress.getHostName()).equalsIgnoreCase(string)) {
                if (string3.equalsIgnoreCase(string2)) {
                    this.host = string2;
                    this.message = this.message.substring(n + 1);
                    this.isHostStrippedFromMessage = true;
                }
                if (this.host == null) {
                    int n2 = string2.indexOf(46);
                    if (n2 > -1) {
                        string2 = string2.substring(0, n2);
                    }
                    if (string3.equalsIgnoreCase(string2)) {
                        this.host = string2;
                        this.message = this.message.substring(n + 1);
                        this.isHostStrippedFromMessage = true;
                    }
                }
            }
            if (this.host == null) {
                this.host = string2 != null ? string2 : string;
            }
        }
    }

    protected void parseDate() {
        if (this.message.length() >= 16 && this.message.charAt(3) == ' ' && this.message.charAt(6) == ' ') {
            String string = Integer.toString(Calendar.getInstance().get(1));
            String string2 = this.message.substring(0, 15) + " " + string;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
            try {
                this.date = simpleDateFormat.parse(string2);
                this.message = this.message.substring(16);
            }
            catch (ParseException parseException) {
                this.date = new Date();
            }
        }
        this.parseHost();
    }

    protected void parsePriority() {
        int n;
        if (this.message.charAt(0) == '<' && (n = this.message.indexOf(">")) <= 4 && n > -1) {
            String string = this.message.substring(1, n);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
                this.facility = n2 >> 3;
                this.level = n2 - (this.facility << 3);
                this.message = this.message.substring(n + 1);
                this.parseDate();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parseHost();
        }
    }

    protected void parse() {
        if (this.message == null) {
            this.message = SyslogUtility.newString(this, this.rawBytes, this.rawLength);
        }
        this.parsePriority();
    }

    public int getFacility() {
        return this.facility;
    }

    public void setFacility(int n) {
        this.facility = n;
    }

    public byte[] getRaw() {
        if (this.rawString != null) {
            byte[] byArray = SyslogUtility.getBytes(this, this.rawString);
            return byArray;
        }
        if (this.rawBytes.length == this.rawLength) {
            return this.rawBytes;
        }
        byte[] byArray = new byte[this.rawLength];
        System.arraycopy(this.rawBytes, 0, byArray, 0, this.rawLength);
        return byArray;
    }

    public int getRawLength() {
        return this.rawLength;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public boolean isHostStrippedFromMessage() {
        return this.isHostStrippedFromMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }
}

