/*
 * Decompiled with CFR 0.152.
 */
package nxd.data;

import java.util.ArrayList;
import java.util.List;
import nxd.data.FirstData;
import nxd.data.GroupUserRelationData;
import nxd.data.UserData;
import nxd.lib.c;
import nxd.o.j;

public class GroupData
extends FirstData {
    public int id = 0;
    public String name = "";
    public String description = "";
    public int policyId = 1;
    public int ftPolicyId = 0;
    public String policyName = "";
    public String ftPolicyName = "";
    public int ldapId = 0;
    public List<UserData> userList = new ArrayList<UserData>();
    public List<GroupUserRelationData> groupUserRelationList = new ArrayList<GroupUserRelationData>();
    public String ftStime = "";
    public String ftEtime = "";
    public List<GroupData> groupList = new ArrayList<GroupData>();
    public String ctime = "";

    @Override
    public void sanitize() {
        this.name = c.a(this.name, 64);
        this.description = c.a(this.description, 100);
        if (c.d(this.ftStime) == 0) {
            this.ftStime = "0000";
        }
        if (c.d(this.ftEtime) == 0) {
            this.ftEtime = "0000";
        }
        if (this.ftStime.compareTo("2400") > 0) {
            this.ftStime = "2400";
        }
        if (this.ftEtime.compareTo("2400") > 0) {
            this.ftEtime = "2400";
        }
        if (this.policyId == 0) {
            this.policyId = 1;
        }
    }

    public String getLdapYn() {
        if (this.ldapId > 0) {
            return "Y";
        }
        return "N";
    }

    public String getUserLine() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (UserData userData : this.userList) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(userData.name);
        }
        return stringBuilder.toString();
    }

    public String getMemberLine() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (UserData firstData : this.userList) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(firstData.name);
        }
        for (GroupData groupData : this.groupList) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*");
            stringBuilder.append(groupData.name);
        }
        return stringBuilder.toString();
    }

    public boolean isLdapGroup() {
        return this.ldapId > 0;
    }

    public String getCtime() {
        return j.b(this.ctime);
    }
}

