/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net.netflow;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import nettrack.log.Log;
import nettrack.net.netflow.Filter;
import nettrack.net.netflow.Flow;
import nettrack.net.netflow.FlowHandler;
import nettrack.net.netflow.V5FlowHandler;

public class Collector
extends Thread {
    protected InetAddress localAddr;
    protected int localPort;
    protected DatagramSocket socket;
    protected FlowHandler[] handlers = new FlowHandler[0];
    HashMap handlersIndex = new HashMap();
    protected int maxPacketSize;
    protected DatagramPacket[] packets;
    protected int maxPackets;
    protected int nextPacket;
    boolean running = true;
    static /* synthetic */ Class class$nettrack$net$netflow$Collector;

    public Collector(int port) throws SocketException {
        this(null, port);
    }

    public Collector(InetAddress addr, int port) throws SocketException {
        this.setName("NetFlow Collector");
        this.localAddr = addr;
        this.localPort = port;
        this.socket = this.localAddr == null ? new DatagramSocket(this.localPort) : new DatagramSocket(this.localPort, this.localAddr);
        this.socket.setSoTimeout(1000);
    }

    public void addFlowHandler(FlowHandler handler) {
        int i;
        FlowHandler[] nh = new FlowHandler[this.handlers.length + 1];
        for (i = 0; i < this.handlers.length; ++i) {
            nh[i] = this.handlers[i];
        }
        nh[i] = handler;
        this.handlers = nh;
        this.handlersIndex.put(handler.getSource(), handler);
        this.maxPacketSize = Math.max(this.maxPacketSize, handler.getMaxPacketSize());
        this.maxPackets += handler.getQueueSize();
        this.packets = new DatagramPacket[this.maxPackets + 1];
        for (i = 0; i < this.maxPackets + 1; ++i) {
            byte[] data = new byte[this.maxPacketSize];
            this.packets[i] = new DatagramPacket(data, this.maxPacketSize);
        }
    }

    public Iterator getFlowHandlers() {
        return new Iterator(){
            int pos = 0;

            public boolean hasNext() {
                return this.pos < Collector.this.handlers.length;
            }

            public Object next() {
                return Collector.this.handlers[this.pos++];
            }

            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    public void run() {
        HashSet<InetAddress> warned = new HashSet<InetAddress>();
        while (this.running) {
            try {
                DatagramPacket packet = this.packets[this.nextPacket++];
                this.nextPacket %= this.packets.length;
                packet.setLength(this.maxPacketSize);
                this.socket.receive(packet);
                if (!this.running) continue;
                InetAddress source = packet.getAddress();
                FlowHandler h = (FlowHandler)this.handlersIndex.get(source);
                if (h != null) {
                    h.put(packet.getData());
                    continue;
                }
                if (warned.contains(source)) continue;
                warned.add(source);
                Log.warning("Packet from unknown source: " + source.getHostAddress());
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {}
        }
    }

    public void destroy() {
        this.running = false;
        this.socket.close();
        for (int i = 0; i < this.handlers.length; ++i) {
            this.handlers[i].destroy();
        }
    }

    public static void main(String[] arg) throws Exception {
        if (arg.length != 2) {
            System.err.println("Usage: java " + (class$nettrack$net$netflow$Collector == null ? (class$nettrack$net$netflow$Collector = Collector.class$("nettrack.net.netflow.Collector")) : class$nettrack$net$netflow$Collector).getName() + " <host> <port>");
            System.exit(1);
        }
        InetAddress source = InetAddress.getByName(arg[0]);
        int port = Integer.parseInt(arg[1]);
        V5FlowHandler handler = new V5FlowHandler(source, 10);
        handler.addFilter(new Filter(){

            public boolean filter(Flow f) {
                return true;
            }

            public void destroy() {
            }

            public Map getStatistics() {
                return new HashMap();
            }
        });
        Collector collector = new Collector(port);
        collector.addFlowHandler(handler);
        collector.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

