<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(DnsSetupDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	DnsSetupData data = dao.selectOne();

	data.dropAttackRequestByDomain = paramBoolean("dropAttackRequestByDomain");
	data.dropAttackRequestByIp = paramBoolean("dropAttackRequestByIp");
	data.dropHostnameWithoutDomain = paramBoolean("dropHostnameWithoutDomain");
	data.dropPtrForPrivateIp = paramBoolean("dropPtrForPrivateIp");
	data.allowPtrForServerIp = paramBoolean("allowPtrForServerIp");

	data.allowedRequestType = paramString("allowedRequestType");
	data.blockedRequestType = paramString("blockedRequestType");

	// Update it.
	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
DnsSetupDao dao = new DnsSetupDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
DnsSetupData data = dao.selectOne();
%>
<%@include file="include/action_info.jsp"%>

<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<!--  -->
<fieldset>
<legend>SERVER PROTECTION</legend>
<table width="100%" class="view">

	<tr>
		<td width="250">
			Drop Attack Request by Domain
			<i class="fa fa-question-circle south-east" title="When there is a domain queried too many times and fills up the request queue rapidly,
				<br>we drop the DNS requests for the domain for less than 1 minute not to flood the request queue."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="dropAttackRequestByDomain" <%if(data.dropAttackRequestByDomain){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Drop Attack Request by IP
			<i class="fa fa-question-circle south-east" title="When there is a client sending abnormal amount of DNS requests,
				<br>we drop the DNS requests from the client for less than 1 minute not to flood the request queue."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="dropAttackRequestByIp" <%if(data.dropAttackRequestByIp){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Drop Hostname without Domain
			<i class="fa fa-question-circle south-east" title="If it's on cloud, you don't need to deal with the hostname only domains."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="dropHostnameWithoutDomain" <%if(data.dropHostnameWithoutDomain){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Drop Reverse Lookup for Private IP
			<i class="fa fa-question-circle south-east" title="If it's on cloud, you don't need to deal with the PTR queries for private IPs."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="dropPtrForPrivateIp" <%if(data.dropPtrForPrivateIp){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td>
			Allow Reverse Lookup for Server IP
			<i class="fa fa-question-circle south-east" title="At default, NxFilter drops revers lookups for itself. You can allow it with this option."></i>
		</td>
		<td><input type="checkbox" class="no-border"
			name="allowPtrForServerIp" <%if(data.allowPtrForServerIp){out.print("checked");}%>></td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
<legend>REQUEST TYPE CONTROL</legend>
<table width="100%" class="view">

	<tr>
		<td width="200">
			Allowed Request Type
			<i class="fa fa-question-circle south-east" title="When you add DNS request types here. Only the specified types of DNS requests will be accepted.<br>
				Other types of requests will be dropped. DNS request types should be added as numbers and should be separated by commas.<br>
				For example, when you add '1,28,5,12', it means you only allow A, AAAA, CNAME, PTR types of DNS requests to your server."></i>
		</td>
		<td>
			<textarea name="allowedRequestType" cols="80" rows="4"><%= data.allowedRequestType%></textarea>
		</td>
	</tr>

	<tr>
		<td>
			Blocked Request Type
			<i class="fa fa-question-circle south-east" title="When you add DNS request types here. The specified types of DNS requests will be dropped.<br>
				DNS request types should be added as numbers and should be separated by commas.<br>
				For example, when you add '255,252', it means you block ANY, AXFR types of DNS requests to your server."></i>
		</td>
		<td>
			<textarea name="blockedRequestType" cols="80" rows="4"><%= data.blockedRequestType%></textarea>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>

<%@include file="include/footer.jsp"%>
