/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.CategoryData;
import nxd.data.CategoryDomainData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.f;

public class CategoryCustomDao
extends FirstDao {
    public int selectCount() {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from category_custom";
        int n2 = b2.f(string);
        b2.close();
        return n2;
    }

    public int selectDomainCount(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from category_domain where category_id = ?";
        int n3 = b2.f(string, new Object[]{n2});
        b2.close();
        return n3;
    }

    public List<CategoryDomainData> selectDomainList(int n2, int n3) {
        ArrayList<CategoryDomainData> arrayList = new ArrayList<CategoryDomainData>();
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from category_domain where category_id = ? order by lower(domain)";
        if (n3 > 0) {
            string = string + " limit " + n3;
        }
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            CategoryDomainData categoryDomainData = new CategoryDomainData();
            categoryDomainData.id = rowSet.getInt("id");
            categoryDomainData.categoryId = rowSet.getInt("category_id");
            categoryDomainData.domain = rowSet.getString("domain");
            arrayList.add(categoryDomainData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public List<CategoryDomainData> selectDomainList(int n2) {
        return this.selectDomainList(n2, 0);
    }

    private CategoryData a(RowSet rowSet) {
        CategoryData categoryData = new CategoryData();
        categoryData.id = rowSet.getInt("id");
        categoryData.name = rowSet.getString("name");
        categoryData.description = rowSet.getString("description");
        categoryData.systemFlag = nxd.lib.c.c((Object)rowSet.getString("system_flag"));
        return categoryData;
    }

    public List<CategoryData> selectList() {
        ArrayList<CategoryData> arrayList = new ArrayList<CategoryData>();
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from category_custom order by system_flag desc, lower(name)";
        RowSet rowSet = b2.l(string);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private boolean a(int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from category_custom where id = ? and system_flag = 'TRUE'", new Object[]{n2});
        b2.close();
        return n3 > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int n2) {
        if (this.a(n2)) {
            this.d.error("CCDd, You can't delete a system category!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from category_domain where category_id = ?";
            b2.c(string, new Object[]{n2});
            string = "delete from category_custom where id = ?";
            b2.c(string, new Object[]{n2});
        }
        this.c.b("category_domain");
        return true;
    }

    private boolean a(CategoryData categoryData) {
        if (!ParamTest.isValidNameLen(categoryData.name)) {
            this.d.error("CCDcP, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidNameChar(categoryData.name)) {
            this.d.error("CCDcP, {}", (Object)"Only alphabet, number, [-_] allowed in name.");
            return false;
        }
        if (ParamTest.isDupCategoryCustom(categoryData.name)) {
            this.d.error("CCDcP, Category already exists!");
            return false;
        }
        return true;
    }

    public boolean insert(CategoryData categoryData) {
        categoryData.sanitize();
        if (!this.a(categoryData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into category_custom(name, description) values(?, ?)";
        boolean bl = b2.d(string, new Object[]{categoryData.name, categoryData.description});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("category");
        return true;
    }

    public CategoryData selectOne(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from category_custom where id = ?";
        RowSet rowSet = b2.m(string, new Object[]{n2});
        if (rowSet == null) {
            b2.close();
            return null;
        }
        CategoryData categoryData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return categoryData;
    }

    public boolean update(CategoryData categoryData) {
        categoryData.sanitize();
        b b2 = DaoUtil.getDbConfig();
        String string = "update category_custom set description = ? where id = ?";
        boolean bl = b2.d(string, new Object[]{categoryData.description, categoryData.id});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        return true;
    }

    public boolean addDomain(CategoryDomainData categoryDomainData, String string, int n2) {
        String[] stringArray;
        categoryDomainData.sanitize();
        for (String string2 : stringArray = categoryDomainData.domain.split("\\s+")) {
            String string3;
            string2 = string2.toLowerCase().trim();
            if (categoryDomainData.categoryId <= 99 && !f.e(string2)) {
                this.d.info("CCDaD, Invalid domain! - {}", (Object)string2);
                continue;
            }
            if (categoryDomainData.categoryId > 99 && !f.f(string2)) {
                this.d.info("CCDaD, Invalid domain! - {}", (Object)string2);
                continue;
            }
            if (ParamTest.hasMaxCustomDomain()) {
                this.d.error("CCDaD, Too many domains!");
                return false;
            }
            b b2 = DaoUtil.getDbConfig();
            if (!b2.b(string3 = "merge into category_domain(category_id, domain) key(domain) values(?, ?)", new Object[]{categoryDomainData.categoryId, string2})) {
                b2.close();
                this.d.error("DB error! - " + string2);
                continue;
            }
            b2.close();
        }
        this.c.b("category_domain");
        return true;
    }

    public boolean addDomain(CategoryDomainData categoryDomainData) {
        return this.addDomain(categoryDomainData, "", 0);
    }

    public boolean deleteDomain(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from category_domain where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("category_domain");
        return true;
    }

    public boolean deleteDomainAll(int n2) {
        String string = "delete from category_domain where category_id = ?";
        try (b b2 = DaoUtil.getDbConfig();){
            b2.b(string, new Object[]{n2});
        }
        this.c.b("category_domain");
        return true;
    }
}

