/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.MobileConfigDao;
import nxd.dao.ParamTest;
import nxd.dao.SearchOption;
import nxd.data.GroupData;
import nxd.data.MobileConfigData;
import nxd.data.UserData;
import nxd.data.UserIpData;
import nxd.data.UserMacData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.e;
import nxd.lib.f;
import nxd.o.q;
import nxd.p;
import org.apache.commons.codec.digest.DigestUtils;

public class UserDao
extends FirstDao {
    private SearchOption a = new SearchOption();
    private Map<Integer, String> b = null;

    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        this.searchOption.addKw("name", string, 2);
        this.searchOption.addKw("description", string, 2);
        this.searchOption.addKw("token", string, 2);
        this.a.addKw("start_ip", string, 2);
        this.a.addKw("end_ip", string, 2);
    }

    private List<UserIpData> a(int n2) {
        ArrayList<UserIpData> arrayList = new ArrayList<UserIpData>();
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from user_ip where user_id = ? order by id";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            UserIpData userIpData = new UserIpData();
            userIpData.id = rowSet.getInt("id");
            userIpData.userId = rowSet.getInt("user_id");
            userIpData.startIp = rowSet.getString("start_ip");
            userIpData.endIp = rowSet.getString("end_ip");
            arrayList.add(userIpData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private List<UserMacData> b(int n2) {
        ArrayList<UserMacData> arrayList = new ArrayList<UserMacData>();
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from user_mac where user_id = ? order by id";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            UserMacData userMacData = new UserMacData();
            userMacData.id = rowSet.getInt("id");
            userMacData.userId = rowSet.getInt("user_id");
            userMacData.mac = rowSet.getString("mac");
            arrayList.add(userMacData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private List<GroupData> c(int n2) {
        ArrayList<GroupData> arrayList = new ArrayList<GroupData>();
        b b2 = DaoUtil.getDbConfig();
        String string = "select a.id id, a.name name from grp a, user_grp b";
        string = string + " where a.id = b.grp_id and user_id = ? order by lower(a.name)";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            GroupData groupData = new GroupData();
            groupData.id = rowSet.getInt("id");
            groupData.name = rowSet.getString("name");
            arrayList.add(groupData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return "";
        }
        String string2 = " or id in (select user_id from user_ip where " + this.a.toSql(12) + ")";
        return " where " + string + string2;
    }

    public int selectCount() {
        String string = this.a();
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from user" + string);
        b2.close();
        return n2;
    }

    private UserData a(RowSet rowSet) {
        if (this.b == null) {
            this.b = DaoUtil.getPolicyIdNameMap();
        }
        UserData userData = new UserData();
        userData.id = rowSet.getInt("id");
        userData.name = rowSet.getString("name");
        userData.passwd = rowSet.getString("passwd");
        userData.description = rowSet.getString("description");
        userData.token = rowSet.getString("token");
        userData.expDate = rowSet.getString("exp_date");
        userData.policyId = rowSet.getInt("policy_id");
        userData.ftPolicyId = rowSet.getInt("ft_policy_id");
        userData.ldapId = rowSet.getInt("ldap_id");
        userData.ctime = rowSet.getString("ctime");
        userData.massFlag = rowSet.getBoolean("mass_flag");
        userData.pwchgCnt = rowSet.getInt("pwchg_cnt");
        userData.policyName = nxd.lib.c.a((Object)this.b.get(userData.policyId));
        userData.ftPolicyName = nxd.lib.c.a((Object)this.b.get(userData.ftPolicyId));
        userData.groupList = this.c(userData.id);
        userData.ipList = this.a(userData.id);
        userData.macList = this.b(userData.id);
        return userData;
    }

    public List<UserData> selectList() {
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<UserData> arrayList = new ArrayList<UserData>();
        String string2 = "select * from user" + string;
        string2 = string2 + String.format(" order by lower(name) limit %s, %s", n2, this.limit);
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string2);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int n2) {
        b b2 = DaoUtil.getDbConfig();
        UserData userData = this.selectOne(n2);
        if (userData == null) {
            return false;
        }
        this.d.info("UDd, Deleting user, {}", (Object)userData.name);
        try {
            String string = "delete from user_ip where user_id = ?";
            b2.c(string, new Object[]{n2});
            string = "delete from user_mac where user_id = ?";
            b2.c(string, new Object[]{n2});
            string = "delete from user_grp where user_id = ?";
            b2.c(string, new Object[]{n2});
            string = "delete from user where id = ?";
            b2.c(string, new Object[]{n2});
        }
        catch (Exception exception) {
            this.d.error("DB error!");
            boolean bl = false;
            return bl;
        }
        finally {
            b2.close();
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    private boolean a(UserData userData) {
        if (!nxd.lib.c.a(userData.passwd) && !nxd.lib.c.g(userData.passwd)) {
            if (!ParamTest.isValidPasswdLen(userData.passwd)) {
                this.d.error("UDcP, {}", (Object)ParamTest.ERR_PASSWD_LEN);
                return false;
            }
            if (!ParamTest.isValidPasswdChar(userData.passwd)) {
                this.d.error("UDcP, {}", (Object)"Only ASCII character allowed in password.");
                return false;
            }
        }
        if (!nxd.lib.c.a(userData.token)) {
            if (!ParamTest.isValidToken(userData.token)) {
                this.d.error("UDcP, {}", (Object)"Not a valid token, only alphabet and number, length must be 8.");
                return false;
            }
            if (ParamTest.isDupToken(userData.id, userData.token)) {
                this.d.error("UDcP, Token already exist!");
                return false;
            }
        }
        return true;
    }

    private boolean b(UserData userData) {
        this.a(userData);
        if (!ParamTest.isValidNameLen(userData.name)) {
            this.d.error("UDcPI, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidUsernameChar(userData.name)) {
            this.d.error("UDcPI, {}", (Object)"Only alphabet, number, [-_] allowed in name.");
            return false;
        }
        if (ParamTest.isDupUser(userData.name)) {
            this.d.error("UDcPI, User already exists!");
            return false;
        }
        return true;
    }

    private boolean c(UserData userData) {
        return this.a(userData);
    }

    public boolean insert(UserData userData) {
        userData.sanitize();
        if (!this.b(userData)) {
            return false;
        }
        if (!nxd.lib.c.a(userData.passwd) && !nxd.lib.c.g(userData.passwd)) {
            userData.passwd = DigestUtils.shaHex((String)userData.passwd);
        }
        b b2 = DaoUtil.getDbConfig();
        if (nxd.lib.c.a(userData.token)) {
            userData.token = nxd.o.p.a(b2, 8);
        }
        String string = "insert into user(name, passwd, description, policy_id, ft_policy_id, exp_date, token, mass_flag)";
        boolean bl = b2.d(string = string + " values(?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{userData.name, userData.passwd, userData.description, userData.policyId, userData.ftPolicyId, userData.expDate, userData.token, userData.massFlag});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        if (userData.grpId > 0) {
            UserData userData2 = this.selectOneByName(userData.name);
            this.joinGroup(userData2.id, new String[]{userData.grpId + ""});
        }
        if (userData.massFlag) {
            return true;
        }
        this.c.b("user");
        return true;
    }

    public void reloadUserDic() {
        DaoUtil.deleteOrphan();
        this.c.b("user");
    }

    private UserData a(String string, Object[] objectArray) {
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.m(string, objectArray);
        if (rowSet == null) {
            b2.close();
            return null;
        }
        UserData userData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return userData;
    }

    public UserData selectOne(int n2) {
        String string = "select * from user where id = ?";
        return this.a(string, new Object[]{n2});
    }

    public UserData selectOneByName(String string) {
        String string2 = "select * from user where name = ?";
        return this.a(string2, new Object[]{string});
    }

    public UserData selectOneByNameAndPassword(String string, String string2) {
        if (!nxd.lib.c.a(string2) && !nxd.lib.c.g(string2)) {
            string2 = DigestUtils.shaHex((String)string2);
        }
        String string3 = "select * from user where name = ? and passwd = ?";
        return this.a(string3, new Object[]{string, string2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updatePw(String string, String string2) {
        if (!nxd.lib.c.a(string2) && !nxd.lib.c.g(string2)) {
            string2 = DigestUtils.shaHex((String)string2);
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string3 = "update user set passwd = ?, pwchg_cnt = pwchg_cnt + 1 where name = ?";
            if (!b2.b(string3, new Object[]{string2, string})) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean a(UserIpData userIpData) {
        if (nxd.lib.c.b(userIpData.endIp) && !f.b(userIpData.endIp)) {
            this.d.error("UDcPIp, Invalid end IP!");
            return false;
        }
        if (f.b(userIpData.endIp) && f.k(userIpData.startIp) > f.k(userIpData.endIp)) {
            this.d.error("UDcPIp, Start IP = {} bigger than End IP = {}.", (Object)userIpData.startIp, (Object)userIpData.endIp);
            return false;
        }
        return true;
    }

    private boolean a(UserMacData userMacData) {
        if (nxd.lib.c.a(userMacData.mac)) {
            this.d.error("UserDao.checkParamMac, Empty MAC!");
            return false;
        }
        if (userMacData.mac.contains(":") && !f.d(userMacData.mac)) {
            this.d.error("UserDao.checkParamMac, Invalid MAC!");
            return false;
        }
        return true;
    }

    public boolean joinGroup(int n2, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        UserData userData = this.selectOne(n2);
        if (userData.ldapId > 0) {
            this.d.error("GroupDao.addGroup, LDAP imported group!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            for (String string : stringArray) {
                String string2 = "select count(*) from user_grp where user_id = ? and grp_id = ?";
                if (b2.f(string2, new Object[]{n2, string}) > 0) continue;
                string2 = "insert into user_grp(user_id, grp_id) values(?, ?)";
                b2.b(string2, new Object[]{n2, string});
            }
        }
        this.c.b("user");
        return true;
    }

    public boolean withdrawGroup(int n2, int n3) {
        UserData userData = this.selectOne(n2);
        if (userData.ldapId > 0) {
            this.d.error("UserDao.delGroup, LDAP imported group!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from user_grp where user_id = ? and grp_id = ?";
            b2.b(string, new Object[]{n2, n3});
        }
        this.c.b("user");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(UserData userData) {
        userData.sanitize();
        if (!this.c(userData)) {
            return false;
        }
        if (!nxd.lib.c.a(userData.passwd) && !nxd.lib.c.g(userData.passwd)) {
            userData.passwd = DigestUtils.shaHex((String)userData.passwd);
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update user set passwd = ?, description = ?";
        string = string + ", policy_id = ?, ft_policy_id = ?, exp_date = ?, token = ? where id = ?";
        try {
            b2.c(string, new Object[]{userData.passwd, userData.description, userData.policyId, userData.ftPolicyId, userData.expDate, userData.token, userData.id});
        }
        catch (Exception exception) {
            this.d.error("DB error! - " + exception.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            b2.close();
        }
        this.c.b("user");
        return true;
    }

    public boolean newToken(int n2) {
        UserData userData = this.selectOne(n2);
        b b2 = DaoUtil.getDbConfig();
        userData.token = nxd.o.p.a(b2, 8);
        b2.close();
        return this.update(userData);
    }

    public boolean addIp(UserIpData userIpData) {
        userIpData.sanitize();
        if (!this.a(userIpData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into user_ip(user_id, start_ip, end_ip) values(?, ?, ?)";
        boolean bl = b2.d(string, new Object[]{userIpData.userId, userIpData.startIp, userIpData.endIp});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    public boolean deleteIp(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from user_ip where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    public boolean addMac(UserMacData userMacData) {
        userMacData.sanitize();
        if (!this.a(userMacData)) {
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from user_mac where mac = ?";
            b2.b(string, new Object[]{userMacData.mac});
            string = "insert into user_mac(user_id, mac) values(?, ?)";
            b2.b(string, new Object[]{userMacData.userId, userMacData.mac});
        }
        this.c.b("user");
        return true;
    }

    public boolean deleteMac(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from user_mac where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("user");
        return true;
    }

    public boolean deleteMassImportedUsers() {
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from user_ip where user_id in (select id from user where mass_flag = true)";
            b2.b(string);
            string = "delete from user_grp where user_id in (select id from user where mass_flag = true)";
            b2.b(string);
            string = "delete from user where mass_flag = true";
            b2.b(string);
        }
        catch (Exception exception) {
            return false;
        }
        this.c.b("user");
        return true;
    }

    public List<String> selectListUname() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "select name from user order by name limit 3000";
            RowSet rowSet = b2.l(string);
            while (rowSet.next()) {
                arrayList.add(rowSet.getString(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public String writeMobileConfigFile(int n2) {
        String string = "";
        UserData userData = this.selectOne(n2);
        MobileConfigData mobileConfigData = new MobileConfigDao().selectOne();
        String string2 = mobileConfigData.template;
        string2 = string2.replace("#{uname}", userData.name);
        string2 = string2.replace("#{token}", userData.token);
        for (int i2 = 1; i2 <= 4; ++i2) {
            string2 = string2.replace("#{uuid" + i2 + "}", UUID.randomUUID().toString().toUpperCase());
        }
        string = p.m + "/" + userData.name + ".mobileconfig";
        e.c(string, string2, "UTF-8");
        return string;
    }

    public static List<GroupData> getAvailGroups(int n2) {
        ArrayList<GroupData> arrayList = new ArrayList<GroupData>();
        String string = "select id, name from grp where ldap_id = 0";
        string = string + "and id not in(";
        string = string + "  select grp_id from user_grp where user_id = ?";
        string = string + ") order by lower(name)";
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.l(string, new Object[]{n2});){
            while (rowSet.next()) {
                int n3 = rowSet.getInt("id");
                String string2 = rowSet.getString("name");
                GroupData groupData = new GroupData();
                groupData.id = n3;
                groupData.name = string2;
                arrayList.add(groupData);
            }
        }
        return arrayList;
    }

    public boolean writeCsvFile(String string) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(new Object[]{"Name", "Description", "Work-time Policy", "Free-time Policy", "Expiration Date", "Login Token", "Creation Time", "IP", "Group"});
        List<UserData> list = this.selectList();
        for (UserData userData : list) {
            Object[] objectArray = new Object[]{userData.name, userData.description, userData.policyName, userData.ftPolicyName, userData.getExpDate(), userData.token, userData.getCtime(), userData.getIpLine(), userData.getGroupLine()};
            arrayList.add(objectArray);
        }
        return q.a(p.m + "/" + string, arrayList);
    }
}

