/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.ZoneFileData;
import nxd.g.n;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.d;
import nxd.lib.e;
import nxd.p;

public class ZoneFileDao
extends FirstDao {
    public int selectCount() {
        try (b b2 = DaoUtil.getDbConfig();){
            int n2 = b2.f("select count(*) from zone_file");
            return n2;
        }
    }

    public ZoneFileData fillData(RowSet rowSet) {
        ZoneFileData zoneFileData = new ZoneFileData();
        zoneFileData.id = rowSet.getInt("id");
        zoneFileData.domain = rowSet.getString("domain");
        zoneFileData.zone = rowSet.getString("zone");
        zoneFileData.bypassAuth = nxd.lib.c.c((Object)rowSet.getString("bypass_auth"));
        zoneFileData.bypassFilter = nxd.lib.c.c((Object)rowSet.getString("bypass_filter"));
        zoneFileData.bypassLog = nxd.lib.c.c((Object)rowSet.getString("bypass_log"));
        zoneFileData.description = rowSet.getString("description");
        return zoneFileData;
    }

    public List<ZoneFileData> selectList() {
        ArrayList<ZoneFileData> arrayList = new ArrayList<ZoneFileData>();
        String string = "select * from zone_file order by domain";
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.l(string);){
            while (rowSet.next()) {
                arrayList.add(this.fillData(rowSet));
            }
        }
        return arrayList;
    }

    public ZoneFileData selectOne(int n2) {
        String string = "select * from zone_file where id = ?";
        ZoneFileData zoneFileData = null;
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.m(string, new Object[]{n2});){
            if (rowSet != null) {
                zoneFileData = this.fillData(rowSet);
            }
        }
        return zoneFileData;
    }

    public boolean delete(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from zone_file where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("zone_file");
        return true;
    }

    private boolean a(ZoneFileData zoneFileData) {
        if (nxd.lib.c.a(zoneFileData.domain)) {
            this.d.error("ZFDcP, Domain missing!");
            return false;
        }
        if (ParamTest.isDupZoneFile(zoneFileData.domain)) {
            this.d.error("ZFDcP, ZoneFile already exists!");
            return false;
        }
        return true;
    }

    public boolean insert(ZoneFileData zoneFileData) {
        zoneFileData.sanitize();
        if (!this.a(zoneFileData)) {
            return false;
        }
        String string = "";
        if (zoneFileData.domain.endsWith(".arpa")) {
            string = e.b(p.j + "/reverse-zone.txt");
        } else {
            string = e.b(p.j + "/primary-zone.txt");
            string = string.replaceAll("example.com", zoneFileData.domain);
        }
        String string2 = nxd.lib.d.a("yyyyMMdd01");
        string = string.replaceAll("#\\{serial\\}", string2);
        b b2 = DaoUtil.getDbConfig();
        String string3 = "insert into zone_file(domain, zone, description) values(?, ?, ?)";
        boolean bl = b2.d(string3, new Object[]{zoneFileData.domain, string, zoneFileData.description});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("zone_file");
        return true;
    }

    public void testZone(ZoneFileData zoneFileData) {
        String string = n.b(zoneFileData.domain, zoneFileData.zone);
        if (nxd.lib.c.a(string)) {
            return;
        }
        throw new Exception(string);
    }

    public boolean update(ZoneFileData zoneFileData) {
        zoneFileData.sanitize();
        try {
            this.testZone(zoneFileData);
        }
        catch (Exception exception) {
            this.d.error("AdminDao.update, " + exception.toString());
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update zone_file set zone = ?, bypass_auth = ?, bypass_filter = ?, bypass_log = ?, description = ? where id = ?";
        boolean bl = b2.d(string, new Object[]{zoneFileData.zone, nxd.lib.c.d(zoneFileData.bypassAuth), nxd.lib.c.d(zoneFileData.bypassFilter), nxd.lib.c.d(zoneFileData.bypassLog), zoneFileData.description, zoneFileData.id});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("zone_file");
        return true;
    }
}

