/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import nettrack.net.IllegalAddress;

public class IpAddr {
    protected int[] ip = new int[4];

    public IpAddr(String ip_) throws IllegalAddress {
        if (ip_.length() == 4) {
            char[] i = ip_.toCharArray();
            this.ip[0] = i[0];
            this.ip[1] = i[1];
            this.ip[2] = i[2];
            this.ip[3] = i[3];
        } else {
            StringTokenizer tok = new StringTokenizer(ip_, ".");
            try {
                this.ip[0] = Integer.parseInt(tok.nextToken());
                this.ip[1] = Integer.parseInt(tok.nextToken());
                this.ip[2] = Integer.parseInt(tok.nextToken());
                this.ip[3] = Integer.parseInt(tok.nextToken());
            }
            catch (NumberFormatException e) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public IpAddr(int[] ip_) {
        this.ip[0] = ip_[0];
        this.ip[1] = ip_[1];
        this.ip[2] = ip_[2];
        this.ip[3] = ip_[3];
    }

    public IpAddr(int a, int b, int c, int d) {
        this.ip[0] = a;
        this.ip[1] = b;
        this.ip[2] = c;
        this.ip[3] = d;
    }

    public IpAddr(int ip_) {
        this.ip[0] = ip_ >> 24 & 0xFF;
        this.ip[1] = ip_ >> 16 & 0xFF;
        this.ip[2] = ip_ >> 8 & 0xFF;
        this.ip[3] = ip_ & 0xFF;
    }

    public IpAddr(long ip_) {
        IpAddr.long2ip(ip_, this.ip);
    }

    protected static void long2ip(long ip_, int[] ip) {
        ip[0] = (int)(ip_ >> 24) & 0xFF;
        ip[1] = (int)(ip_ >> 16) & 0xFF;
        ip[2] = (int)(ip_ >> 8) & 0xFF;
        ip[3] = (int)ip_ & 0xFF;
    }

    public int[] getIntArray() {
        return this.ip;
    }

    public int hashCode() {
        return (int)this.longValue();
    }

    public boolean equals(Object o) {
        if (o instanceof IpAddr) {
            IpAddr ip_ = (IpAddr)o;
            return this.ip[0] == ip_.ip[0] && this.ip[1] == ip_.ip[1] && this.ip[2] == ip_.ip[2] && this.ip[3] == ip_.ip[3];
        }
        return false;
    }

    public long longValue() {
        return (long)((this.ip[0] << 8 | this.ip[1]) << 8 | this.ip[2]) << 8 | (long)this.ip[3];
    }

    public String toString() {
        return "" + this.ip[0] + "." + this.ip[1] + "." + this.ip[2] + "." + this.ip[3];
    }

    public InetAddress inetAddr() {
        try {
            return InetAddress.getByName(this.toString());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String toString(long ip_) {
        int[] ip = new int[4];
        IpAddr.long2ip(ip_, ip);
        return ip[0] + "." + ip[1] + "." + ip[2] + "." + ip[3];
    }
}

