/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net.netflow;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nettrack.net.netflow.Accountant;
import nettrack.net.netflow.Filter;
import nettrack.net.netflow.Flow;
import nettrack.net.netflow.FlowHeader;
import nettrack.util.AsyncBoundedFifo;

public abstract class FlowHandler
extends AsyncBoundedFifo {
    protected FlowHeader header;
    protected Flow flow;
    private Filter[] filters = new Filter[0];
    private Accountant[] accountants = new Accountant[0];
    private long totalPackets = 0L;
    private long validPackets = 0L;
    private long totalFlows = 0L;
    private long filteredFlows = 0L;
    private InetAddress sourceAddr;

    public FlowHandler(InetAddress source, int fifosize) {
        super(fifosize);
        this.sourceAddr = source;
    }

    public FlowHandler(Map configuration) throws Exception {
        this(InetAddress.getByName((String)configuration.get("source")), Integer.parseInt((String)configuration.get("fifosize")));
    }

    public void destroy() {
        int i;
        super.destroy();
        for (i = 0; i < this.filters.length; ++i) {
            this.filters[i].destroy();
        }
        for (i = 0; i < this.accountants.length; ++i) {
            this.accountants[i].destroy();
        }
    }

    public void addFilter(Filter f) {
        Filter[] nf = new Filter[this.filters.length + 1];
        for (int i = 0; i < this.filters.length; ++i) {
            nf[i] = this.filters[i];
        }
        nf[i] = f;
        this.filters = nf;
    }

    public Iterator getFilters() {
        return new Iterator(){
            int pos = 0;

            public boolean hasNext() {
                return this.pos < FlowHandler.this.filters.length;
            }

            public Object next() {
                return FlowHandler.this.filters[this.pos++];
            }

            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    public void addAccountant(Accountant a) {
        Accountant[] na = new Accountant[this.accountants.length + 1];
        for (int i = 0; i < this.accountants.length; ++i) {
            na[i] = this.accountants[i];
        }
        na[i] = a;
        this.accountants = na;
    }

    public Iterator getAccountants() {
        return new Iterator(){
            int pos = 0;

            public boolean hasNext() {
                return this.pos < FlowHandler.this.accountants.length;
            }

            public Object next() {
                return FlowHandler.this.accountants[this.pos++];
            }

            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    public boolean handle(Object element) {
        byte[] data = (byte[])element;
        this.header.setData(data);
        ++this.totalPackets;
        if (!this.checkHeader(this.header)) {
            return true;
        }
        ++this.validPackets;
        for (int i = 0; i < this.header.getCount(); ++i) {
            int j;
            this.flow.setData(data, this.getHeaderSize() + i * this.getFlowSize());
            ++this.totalFlows;
            boolean filtered = false;
            for (j = 0; !filtered && j < this.filters.length; ++j) {
                filtered = this.filters[j].filter(this.flow);
            }
            if (filtered) {
                ++this.filteredFlows;
                continue;
            }
            for (j = 0; j < this.accountants.length; ++j) {
                this.accountants[j].account(this.flow);
            }
        }
        return true;
    }

    public InetAddress getSource() {
        return this.sourceAddr;
    }

    public Map getStatistics() {
        HashMap<String, Long> statistics = new HashMap<String, Long>();
        statistics.put("total packets", new Long(this.totalPackets));
        statistics.put("valid packets", new Long(this.validPackets));
        statistics.put("total flows", new Long(this.totalFlows));
        statistics.put("filtered flows", new Long(this.filteredFlows));
        return statistics;
    }

    public abstract int getVersion();

    public abstract int getHeaderSize();

    public abstract int getFlowSize();

    public abstract int getMaxFlowsPerPacket();

    public int getMaxPacketSize() {
        return this.getHeaderSize() + this.getFlowSize() * this.getMaxFlowsPerPacket();
    }

    public abstract boolean checkHeader(FlowHeader var1);
}

