/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net.netflow;

import nettrack.net.IpAddr;
import nettrack.net.netflow.Flow;
import nettrack.util.ByteUtil;

public class V5Flow
extends Flow {
    public int getLength() {
        return 48;
    }

    public int getTcpFlags() {
        return ByteUtil.getUByte(this.data, this.offset + 37);
    }

    public int getProt() {
        return ByteUtil.getUByte(this.data, this.offset + 38);
    }

    public int getTOS() {
        return ByteUtil.getUByte(this.data, this.offset + 39);
    }

    public int getSrcAS() {
        return ByteUtil.getUShort(this.data, this.offset + 40);
    }

    public int getDstAS() {
        return ByteUtil.getUShort(this.data, this.offset + 42);
    }

    public int getSrcMask() {
        return ByteUtil.getUByte(this.data, this.offset + 44);
    }

    public int getDstMask() {
        return ByteUtil.getUByte(this.data, this.offset + 45);
    }

    public String toString() {
        return super.toString() + "\n" + "TcpFlags: " + this.getTcpFlags() + "\n" + "Prot: " + this.getProt() + "\n" + "TOS: " + this.getTOS() + "\n" + "SrcAS: " + this.getSrcAS() + "\n" + "DstAS: " + this.getDstAS() + "\n" + "SrcMask: " + this.getSrcMask() + "\n" + "DstMask: " + this.getDstMask();
    }

    public String toShortString() {
        return IpAddr.toString(this.getSrcAddr()) + "." + this.getSrcPort() + " -> " + IpAddr.toString(this.getDstAddr()) + "." + this.getDstPort() + " " + this.getDOctets() + " " + this.getProt();
    }
}

