/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net.netflow;

import java.net.InetAddress;
import java.util.Map;
import nettrack.net.netflow.FlowHandler;
import nettrack.net.netflow.FlowHeader;
import nettrack.net.netflow.V6Flow;
import nettrack.net.netflow.V6FlowHeader;

public class V6FlowHandler
extends FlowHandler {
    private long nextFlow = -1L;
    private long missedFlows = 0L;
    private long aheadTimes = 0L;

    public V6FlowHandler(InetAddress source, int fifoSize) {
        super(source, fifoSize);
        this.header = new V6FlowHeader();
        this.flow = new V6Flow();
    }

    public int getVersion() {
        return 6;
    }

    public int getHeaderSize() {
        return 24;
    }

    public int getFlowSize() {
        return 52;
    }

    public int getMaxFlowsPerPacket() {
        return 27;
    }

    public Map getStatistics() {
        Map statistics = super.getStatistics();
        statistics.put("missed flows", new Long(this.missedFlows));
        statistics.put("number of times ahead", new Long(this.aheadTimes));
        return statistics;
    }

    public boolean checkHeader(FlowHeader header) {
        long flowNumber = ((V6FlowHeader)header).getFlowSequence();
        if (this.nextFlow != -1L && this.nextFlow != flowNumber) {
            if (flowNumber > this.nextFlow) {
                this.missedFlows += flowNumber - this.nextFlow;
            } else {
                ++this.aheadTimes;
            }
        }
        this.nextFlow = flowNumber + (long)header.getCount();
        return true;
    }
}

