/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.productivity.java.syslog4j.SyslogConstants;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerConfigIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.SyslogServerMain;
import org.productivity.java.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfig;
import org.productivity.java.syslog4j.server.impl.net.udp.UDPNetSyslogServerConfig;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class SyslogServer
implements SyslogConstants {
    private static final long serialVersionUID = -2260889360828258602L;
    private static boolean SUPPRESS_RUNTIME_EXCEPTIONS = false;
    protected static final Map instances = new Hashtable();

    private SyslogServer() {
    }

    public static final String getVersion() {
        return "Syslog4j 0.9.46 2011-01-23 14:49:24 jpy";
    }

    public static void setSuppressRuntimeExceptions(boolean bl) {
        SUPPRESS_RUNTIME_EXCEPTIONS = bl;
    }

    public static boolean getSuppressRuntimeExceptions() {
        return SUPPRESS_RUNTIME_EXCEPTIONS;
    }

    private static void throwRuntimeException(String string) throws SyslogRuntimeException {
        if (SUPPRESS_RUNTIME_EXCEPTIONS) {
            return;
        }
        throw new SyslogRuntimeException(string.toString());
    }

    public static final SyslogServerIF getInstance(String string) throws SyslogRuntimeException {
        String string2 = string.toLowerCase();
        if (instances.containsKey(string2)) {
            return (SyslogServerIF)instances.get(string2);
        }
        SyslogServer.throwRuntimeException("SyslogServer instance \"" + string2 + "\" not defined; use \"tcp\" or \"udp\" or call SyslogServer.createInstance(protocol,config) first");
        return null;
    }

    public static final SyslogServerIF getThreadedInstance(String string) throws SyslogRuntimeException {
        SyslogServerIF syslogServerIF = SyslogServer.getInstance(string);
        if (syslogServerIF.getThread() == null) {
            Thread thread = new Thread(syslogServerIF);
            thread.setName("SyslogServer: " + string);
            thread.setDaemon(syslogServerIF.getConfig().isUseDaemonThread());
            if (syslogServerIF.getConfig().getThreadPriority() > -1) {
                thread.setPriority(syslogServerIF.getConfig().getThreadPriority());
            }
            syslogServerIF.setThread(thread);
            thread.start();
        }
        return syslogServerIF;
    }

    public static final boolean exists(String string) {
        if (string == null || "".equals(string.trim())) {
            return false;
        }
        return instances.containsKey(string.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SyslogServerIF createInstance(String string, SyslogServerConfigIF syslogServerConfigIF) throws SyslogRuntimeException {
        if (string == null || "".equals(string.trim())) {
            SyslogServer.throwRuntimeException("Instance protocol cannot be null or empty");
            return null;
        }
        if (syslogServerConfigIF == null) {
            SyslogServer.throwRuntimeException("SyslogServerConfig cannot be null");
            return null;
        }
        String string2 = string.toLowerCase();
        SyslogServerIF syslogServerIF = null;
        Map map = instances;
        synchronized (map) {
            if (instances.containsKey(string2)) {
                SyslogServer.throwRuntimeException("SyslogServer instance \"" + string2 + "\" already defined.");
                return null;
            }
            try {
                Class clazz = syslogServerConfigIF.getSyslogServerClass();
                syslogServerIF = (SyslogServerIF)clazz.newInstance();
            }
            catch (ClassCastException classCastException) {
                throw new SyslogRuntimeException(classCastException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SyslogRuntimeException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new SyslogRuntimeException(instantiationException);
            }
            syslogServerIF.initialize(string2, syslogServerConfigIF);
            instances.put(string2, syslogServerIF);
        }
        return syslogServerIF;
    }

    public static final SyslogServerIF createThreadedInstance(String string, SyslogServerConfigIF syslogServerConfigIF) throws SyslogRuntimeException {
        SyslogServer.createInstance(string, syslogServerConfigIF);
        SyslogServerIF syslogServerIF = SyslogServer.getThreadedInstance(string);
        return syslogServerIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(String string) {
        if (string == null || "".equals(string.trim())) {
            return;
        }
        String string2 = string.toLowerCase();
        if (instances.containsKey(string2)) {
            SyslogUtility.sleep(500L);
            SyslogServerIF syslogServerIF = (SyslogServerIF)instances.get(string2);
            try {
                syslogServerIF.shutdown();
            }
            finally {
                instances.remove(string2);
            }
        } else {
            SyslogServer.throwRuntimeException("Cannot destroy server protocol \"" + string + "\" instance; call shutdown instead");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized void destroyInstance(SyslogServerIF syslogServerIF) {
        if (syslogServerIF == null) {
            return;
        }
        String string = syslogServerIF.getProtocol().toLowerCase();
        if (instances.containsKey(string)) {
            SyslogUtility.sleep(500L);
            try {
                syslogServerIF.shutdown();
            }
            finally {
                instances.remove(string);
            }
        } else {
            SyslogServer.throwRuntimeException("Cannot destroy server protocol \"" + string + "\" instance; call shutdown instead");
        }
    }

    public static synchronized void initialize() {
        SyslogServer.createInstance("udp", new UDPNetSyslogServerConfig());
        SyslogServer.createInstance("tcp", new TCPNetSyslogServerConfig());
    }

    public static final synchronized void shutdown() throws SyslogRuntimeException {
        Set set = instances.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SyslogServerIF syslogServerIF = (SyslogServerIF)instances.get(string);
            syslogServerIF.shutdown();
        }
        instances.clear();
    }

    public static void main(String[] stringArray) throws Exception {
        SyslogServerMain.main(stringArray);
    }

    static {
        SyslogServer.initialize();
    }
}

