/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.util.StringTokenizer;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.util.RadiusException;

public class IpAttribute
extends RadiusAttribute {
    public IpAttribute() {
    }

    public IpAttribute(int type, String value) {
        this.setAttributeType(type);
        this.setAttributeValue(value);
    }

    public IpAttribute(int type, long ipNum) {
        this.setAttributeType(type);
        this.setIpAsLong(ipNum);
    }

    public String getAttributeValue() {
        StringBuffer ip = new StringBuffer();
        byte[] data = this.getAttributeData();
        if (data == null || data.length != 4) {
            throw new RuntimeException("ip attribute: expected 4 bytes attribute data");
        }
        ip.append(data[0] & 0xFF);
        ip.append(".");
        ip.append(data[1] & 0xFF);
        ip.append(".");
        ip.append(data[2] & 0xFF);
        ip.append(".");
        ip.append(data[3] & 0xFF);
        return ip.toString();
    }

    public void setAttributeValue(String value) {
        if (value == null || value.length() < 7 || value.length() > 15) {
            throw new IllegalArgumentException("bad IP number");
        }
        StringTokenizer tok = new StringTokenizer(value, ".");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("bad IP number: 4 numbers required");
        }
        byte[] data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int num = Integer.parseInt(tok.nextToken());
            if (num < 0 || num > 255) {
                throw new IllegalArgumentException("bad IP number: num out of bounds");
            }
            data[i] = (byte)num;
        }
        this.setAttributeData(data);
    }

    public long getIpAsLong() {
        byte[] data = this.getAttributeData();
        if (data == null || data.length != 4) {
            throw new RuntimeException("expected 4 bytes attribute data");
        }
        return (long)(data[0] & 0xFF) << 24 | (long)((data[1] & 0xFF) << 16) | (long)((data[2] & 0xFF) << 8) | (long)(data[3] & 0xFF);
    }

    public void setIpAsLong(long ip) {
        byte[] data = new byte[]{(byte)(ip >> 24 & 0xFFL), (byte)(ip >> 16 & 0xFFL), (byte)(ip >> 8 & 0xFFL), (byte)(ip & 0xFFL)};
        this.setAttributeData(data);
    }

    public void readAttribute(byte[] data, int offset, int length) throws RadiusException {
        if (length != 6) {
            throw new RadiusException("IP attribute: expected 4 bytes data");
        }
        super.readAttribute(data, offset, length);
    }
}

