/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.dictionary;

import java.io.IOException;
import java.io.InputStream;
import org.tinyradius.dictionary.Dictionary;
import org.tinyradius.dictionary.DictionaryParser;
import org.tinyradius.dictionary.MemoryDictionary;

public class DefaultDictionary
extends MemoryDictionary {
    private static final String DICTIONARY_RESOURCE = "org/tinyradius/dictionary/default_dictionary";
    private static DefaultDictionary instance = null;

    public static Dictionary getDefaultDictionary() {
        return instance;
    }

    private DefaultDictionary() {
    }

    static {
        try {
            instance = new DefaultDictionary();
            InputStream source = DefaultDictionary.class.getClassLoader().getResourceAsStream(DICTIONARY_RESOURCE);
            DictionaryParser.parseDictionary(source, instance);
        }
        catch (IOException e) {
            throw new RuntimeException("default dictionary unavailable", e);
        }
    }
}

