<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void insert(DhcpAllowedMacDao dao){
	String macAll = paramString("mac");
	String description = paramString("description");

	// Param validation.
	if(isEmpty(macAll)){
		return;
	}

	String[] arr = macAll.split("\\s+");
	for (String mac : arr) {
		mac = mac.trim();

		if (!ParamTest.isValidMac(mac)) {
			continue;
		}

		if (ParamTest.isDupDhcpAllowedMac(mac)) {
			continue;
		}

		DhcpAllowedMacData data = new DhcpAllowedMacData();
		data.mac = mac;
		data.description = description;
		dao.insert(data);
	}
}

//-----------------------------------------------
void delete(DhcpAllowedMacDao dao){
	if(dao.delete(paramInt("id"))){
		succList.add(translate("Update finished."));
	}
}

//-----------------------------------------------
void deleteAll(DhcpAllowedMacDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	dao.deleteAll();
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
DhcpAllowedMacDao dao = new DhcpAllowedMacDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("insert")){
	insert(dao);
}
if(actionFlag.equals("delete")){
	delete(dao);
}
if(actionFlag.equals("deleteAll")){
	deleteAll(dao);
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item">DHCP</li>
		<li class="breadcrumb-item text-info"><%= translate("ALLOWED MAC")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Form -->
<div class="container-fluid">
	<div class="card bg-light m-2 expand-lg">
		<div class="card-body">
			<form action="<%= getPageName()%>" method="post">
				<input type="hidden" name="actionFlag" value="insert">

				<div class="form-group col-lg-8 text-secondary">
					<%= translate("This is a DHCP level access control. Once MAC addresses are registered here, only those can lease IP addresses from the DHCP server.")%>
				</div>

				<div class="form-group col-lg-8">
					<label class="col-form-label">
						<%= translate("MAC Address")%>
						&nbsp;<i class="fa fa-question-circle south-east"
							title="<%= translate("You can add multiple MAC addresses separated by spaces.")%>"></i>
					</label>
					<textarea class="form-control" id="mac" name="mac"></textarea>
				</div>
				<div class="form-group col-lg-8">
					<label class="col-form-label"><%= translate("Description")%></label>
					<input type="text" class="form-control" id="description" name="description">
				</div>
				<div class="form-group col-lg-8">
					<button type="submit" class="btn btn-primary"><%= translate("SUBMIT")%></button>
					<button type="button" class="btn btn-warning" onclick="javascript:actionDeleteAll();"><%= translate("DELETE ALL")%></button>
				</div>
			</form>
		</div>
	</div>
</div>
<!-- /Form -->

<!-- List -->
<div id="listDiv" class="container-fluid" style="display: none;">
	<div class="m-2 expand-lg">
		<table id="list" class="cell-border hover" style="width:100%">
			<thead>
				<tr>
					<th>MAC</th>
					<th><%= translate("Description")%></th>
					<th></th>
				</tr>
			</thead>
			<tbody>
<%
List<DhcpAllowedMacData> dataList = dao.selectList();
for(int i = 0; i < dataList.size(); i++){
	DhcpAllowedMacData data = dataList.get(i);
%>
				<tr>
					<td><%= data.mac%></td>
					<td><%= data.description%></td>
					<td>
						<i class="fa fa-trash pointer-cursor" title="<%= translate("Delete")%>" onclick="javascript:actionDelete(<%= data.id%>, '<%= data.mac%>')"></i>
					</td>
				</tr>
<%}%>
			</tbody>
		</table>
	</div>
</div>
<!-- /List -->

<!-- goForm -->
<form name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>

<script>
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"bLengthChange" : false,
		"ordering" : false,
		"info" : true,
		"initComplete": function(settings, json){
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
function actionDelete(id, mac){
	if(!confirm('<%= translate("Deleting MAC address")%> : ' +  mac)){
		return;
	}

	var form = document.goForm;
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
function actionDeleteAll(){
	if(!confirm('<%= translate("Deleting all?")%>')){
		return;
	}

	var form = document.goForm;
	form.action = "<%= getPageName()%>";
	form.actionFlag.value = "deleteAll";
	form.submit();
}

//-----------------------------------------------
// Prevent submit again.
if(window.history.replaceState){
	window.history.replaceState(null, null, window.location.href);
}
</script>
