<%@page trimDirectiveWhitespaces="true"%>
<%@page import="java.io.*"%>
<%@page import="java.util.*"%>
<%@page import="org.json.simple.*"%>
<%@page import="nxd.dao.*"%>
<%@page import="nxd.data.*"%>
<%!
//##################################################################################################
// User and group.
//-----------------------------------------------
JSONObject groupUserRelationDataToJson(GroupUserRelationData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("userId", data.userId);
	obj.put("groupId", data.groupId);
	obj.put("userName", data.userName);
	obj.put("groupName", data.groupName);

	return obj;
}

//-----------------------------------------------
JSONObject groupDataToJson(GroupData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("id", data.id);
	obj.put("name", data.name);
	obj.put("description", data.description);

	obj.put("policyId", data.policyId);
	obj.put("ftPolicyId", data.ftPolicyId);
	obj.put("policyName", data.policyName);
	obj.put("ftPolicyName", data.ftPolicyName);

	obj.put("ldapId", data.policyId);

	obj.put("ftStime", data.ftStime);
	obj.put("ftEtime", data.ftEtime);

	JSONArray userList = new JSONArray();
	for(UserData user : data.userList){
		userList.add(userDataToJson(user));
	}
	obj.put("userList", userList);

	JSONArray groupUserRelationList = new JSONArray();
	for(GroupUserRelationData rel : data.groupUserRelationList){
		groupUserRelationList.add(groupUserRelationDataToJson(rel));
	}
	obj.put("groupUserRelationList", groupUserRelationList);

	return obj;
}

//-----------------------------------------------
JSONObject userIpDataToJson(UserIpData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("id", data.id);
	obj.put("userId", data.userId);
	obj.put("startIp", data.startIp);
	obj.put("endIp", data.endIp);
	return obj;
}

//-----------------------------------------------
JSONObject userDataToJson(UserData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("id", data.id);
	obj.put("name", data.name);
	obj.put("description", data.description);
	obj.put("token", data.token);
	obj.put("expDate", data.expDate);

	obj.put("policyId", data.policyId);
	obj.put("ftPolicyId", data.ftPolicyId);
	obj.put("policyName", data.policyName);
	obj.put("ftPolicyName", data.ftPolicyName);

	obj.put("ldapId", data.policyId);
	obj.put("grpId", data.grpId);

	JSONArray ipList = new JSONArray();
	for(UserIpData uip : data.ipList){
		ipList.add(userIpDataToJson(uip));
	}
	obj.put("ipList", ipList);


	JSONArray groupList = new JSONArray();
	for(GroupData grp : data.groupList){
		groupList.add(groupDataToJson(grp));
	}
	obj.put("groupList", groupList);

	return obj;
}

//-----------------------------------------------
JSONArray userListToJson(List<UserData> dataList){
	JSONArray resList = new JSONArray();
	for(int i = 0; i < dataList.size(); i++){
		UserData data = dataList.get(i);
		JSONObject obj = userDataToJson(data);
		resList.add(obj);
	}
	return resList;
}

//##################################################################################################
// Category.
//-----------------------------------------------
JSONObject categoryDataToJson(CategoryData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("id", data.id);
	obj.put("name", data.name);
	obj.put("description", data.description);
	obj.put("systemFlag", data.systemFlag);
	obj.put("domainCount", data.getDomainCount());

	return obj;
}

//-----------------------------------------------
JSONObject categoryDomainDataToJson(CategoryDomainData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("id", data.id);
	obj.put("categoryId", data.categoryId);
	obj.put("domain", data.domain);

	return obj;
}

//-----------------------------------------------
JSONObject categoryDataToJsonWithDomainList(CategoryData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj = categoryDataToJson(data);

	obj.put("id", data.id);
	obj.put("name", data.name);
	obj.put("description", data.description);
	obj.put("systemFlag", data.systemFlag);

	JSONArray domainList = new JSONArray();
	for(CategoryDomainData cdd : data.getDomainList()){
		domainList.add(categoryDomainDataToJson(cdd));
	}
	obj.put("domainList", domainList);

	return obj;
}

//-----------------------------------------------
JSONArray categoryListToJson(List<CategoryData> dataList){
	JSONArray resList = new JSONArray();
	for(int i = 0; i < dataList.size(); i++){
		CategoryData data = dataList.get(i);
		JSONObject obj = categoryDataToJson(data);
		resList.add(obj);
	}
	return resList;
}

//-----------------------------------------------
JSONObject domainTestDataToJson(DomainTestData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("domain", data.domain);
	obj.put("category", data.category);

	return obj;
}

//##################################################################################################
// Whitelist.
//-----------------------------------------------
JSONObject whitelistDataToJson(WhitelistData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("id", data.id);
	obj.put("domain", data.domain);
	obj.put("keyword", data.keyword);
	obj.put("description", data.description);
	
	obj.put("bypassAuth", data.bypassAuth);
	obj.put("bypassFilter", data.bypassFilter);
	obj.put("bypassLog", data.bypassLog);
	obj.put("adminBlock", data.adminBlock);
	obj.put("dropPacket", data.dropPacket);

	JSONArray appliedPolcyArr = new JSONArray();
	for(String ap : data.appliedPolicyArr){
		appliedPolcyArr.add(ap);
	}
	obj.put("appliedPolcyArr", appliedPolcyArr);

	JSONObject appliedPolicyMap = new JSONObject();
	for(Map.Entry<Integer, PolicyData> entry : data.appliedPolicyMap.entrySet()){
		//appliedPolicyMap.put(entry.getKey(), policyDataToJson(entry.getValue()));
		
		// We only need policy id and name.
		appliedPolicyMap.put(entry.getKey(), entry.getValue().name);
	}
	obj.put("appliedPolicyMap", appliedPolicyMap);

	return obj;
}

//-----------------------------------------------
JSONArray whitelistListToJson(List<WhitelistData> dataList){
	JSONArray resList = new JSONArray();
	for(int i = 0; i < dataList.size(); i++){
		WhitelistData data = dataList.get(i);
		JSONObject obj = whitelistDataToJson(data);
		resList.add(obj);
	}
	return resList;
}

//##################################################################################################
// Policy.
//-----------------------------------------------
JSONObject policyDataToJson(PolicyData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj.put("id", data.id);
	obj.put("name", data.name);
	obj.put("points", data.points);
	obj.put("description", data.description);
	
	obj.put("enableFilter", data.enableFilter);
	obj.put("blockAll", data.blockAll);
	obj.put("blockUnclass", data.blockUnclass);
	obj.put("adRemove", data.adRemove);

	obj.put("maxDomainLen", data.maxDomainLen);
	obj.put("blockCovertChan", data.blockCovertChan);
	obj.put("blockMailerWorm", data.blockMailerWorm);

	obj.put("aRecordOnly", data.aRecordOnly);
	obj.put("quota", data.quota);
	obj.put("quotaAll", data.quotaAll);

	obj.put("bwdtLimit", data.bwdtLimit);
	obj.put("logOnly", data.logOnly);
	obj.put("blockCategory", data.blockCategory);
	obj.put("quotaCategory", data.quotaCategory);

	obj.put("systemFlag", data.systemFlag);
	obj.put("safeMode", data.safeMode);
	obj.put("safeModeWithoutYoutube", data.safeModeWithoutYoutube);

	obj.put("btStime", data.btStime);
	obj.put("btEtime", data.btEtime);

	return obj;
}

//-----------------------------------------------
JSONObject policyDataToJsonWithCategoryList(PolicyData data){
	JSONObject obj = new JSONObject();
	if(data == null){
		return obj;
	}

	obj = policyDataToJson(data);

	obj.put("blockCategoryList", categoryListToJson(data.getBlockCategoryList()));
	obj.put("quotaCategoryList", categoryListToJson(data.getQuotaCategoryList()));

	return obj;
}
%>