<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addReport();

//Check permission.
if(!checkPermission()){
	return;
}

// If there's a user it becomes user specific report.
String stime = paramString("stime");
String user = paramString("user");

// Create data access object.
D7ReportDao dao = new D7ReportDao(stime, user);
ReportStatsData stats = dao.getStats();
ReportChartData requestTrend = dao.getRequestTrend();
ReportChartData domainTop = dao.getDomainTop(5);
ReportChartData categoryTop = dao.getCategoryTop(5);
ReportChartData userTop = dao.getUserTop(5);
ReportChartData cltIpTop = dao.getCltIpTop(5);

// Global.
String gTimeOption = paramString("timeOption", "last7days");
String gUser = paramString("user");

String gPieStime = strftimeNewFmt("yyyyMMdd", "yyyyMMdd 00:00", dao.stime);
String gPieEtime = strftimeAdd("yyyyMMdd", dao.stime, 86400 * 7) + " 00:00";
%>

<script type="text/javascript">
//-----------------------------------------------
function setUserdef(form){
	form.timeOption[0].checked = true;
}

//-----------------------------------------------
function setPeriod(form){
	var opt = radioGetValue(form.timeOption);

	var stime = '<%= strftimeAdd(getGuiDateFormatWithYear(), -86400 * 7)%>';

	if(opt == "1week"){
		stime = '<%= strftimeAdd(getGuiDateFormatWithYear(), -86400 * 7 * 2)%>';
	}

	if(opt == "2weeks"){
		stime = '<%= strftimeAdd(getGuiDateFormatWithYear(), -86400 * 7 * 3)%>';
	}

	if(opt == "3weeks"){
		stime = '<%= strftimeAdd(getGuiDateFormatWithYear(), -86400 * 7 * 4)%>';
	}

	form.stime.value = stime;
	form.stime.disabled = false;
}

//-----------------------------------------------
function setPeriod2(form){
	if(!radioIsChecked(form.timeOption) || form.timeOption[0].checked){
		return;
	}
	setPeriod(form);
}
</script>

<!-- Google chart -->
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script type="text/javascript">
google.load("visualization", "1", {packages:["corechart"]});

// Draw request trend chart.
google.setOnLoadCallback(drawRequestTrend);
function drawRequestTrend() {
	var data = google.visualization.arrayToDataTable([
		["Time", "Request"]
<%
List<String[]> arrList = requestTrend.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TREND FOR 7 DAYS",
		legend: {position: "none"},
	};

	var chart = new google.visualization.AreaChart(document.getElementById("chartRequestTrend"));
	chart.draw(data, options);
}

// Draw block trend chart.
google.setOnLoadCallback(drawBlockTrend);
function drawBlockTrend() {
	var data = google.visualization.arrayToDataTable([
		["Time", "Block"]
<%
arrList = requestTrend.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TREND FOR 7 DAYS",
		legend: {position: "none"},
		colors: ["red"],
	};

	var chart = new google.visualization.AreaChart(document.getElementById("chartBlockTrend"));
	chart.draw(data, options);
}

// Draw domain top chart.
google.setOnLoadCallback(drawDomainTop);
function drawDomainTop() {
	var data = google.visualization.arrayToDataTable([
		["Domain", "Request"]
<%
arrList = domainTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TOP 5 DOMAINS",
		is3D: true,
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartDomainTop"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?domain=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw domain block chart.
google.setOnLoadCallback(drawDomainBlock);
function drawDomainBlock() {
	var data = google.visualization.arrayToDataTable([
		["Domain", "Block"]
<%
arrList = domainTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TOP 5 DOMAINS",
		is3D: true,
		slices: {3: {offset: 0.3},},
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartDomainBlock"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?blockFlag=on&domain=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw category top chart.
google.setOnLoadCallback(drawCategoryTop);
function drawCategoryTop() {
	var data = google.visualization.arrayToDataTable([
		["Category", "Request"]
<%
arrList = categoryTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TOP 5 CATEGORIES",
		is3D: true,
		slices: {3: {offset: 0.3},},
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartCategoryTop"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?category=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw category block chart.
google.setOnLoadCallback(drawCategoryBlock);
function drawCategoryBlock() {
	var data = google.visualization.arrayToDataTable([
		["Category", "Block"]
<%
arrList = categoryTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TOP 5 CATEGORIES",
		is3D: true,
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartCategoryBlock"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?blockFlag=on&category=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw user top chart.
google.setOnLoadCallback(drawUserTop);
function drawUserTop() {
	var data = google.visualization.arrayToDataTable([
		["User", "Request"]
<%
arrList = userTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TOP 5 USERS",
		is3D: true,
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartUserTop"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?user=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw user block chart.
google.setOnLoadCallback(drawUserBlock);
function drawUserBlock() {
	var data = google.visualization.arrayToDataTable([
		["User", "Block"]
<%
arrList = userTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TOP 5 USERS",
		is3D: true,
		slices: {3: {offset: 0.3},},
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartUserBlock"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?blockFlag=on&user=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw cltIp top chart.
google.setOnLoadCallback(drawCltIpTop);
function drawCltIpTop() {
	var data = google.visualization.arrayToDataTable([
		["IP", "Request"]
<%
arrList = cltIpTop.getDataList();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "REQUEST TOP 5 CLIENT IPS",
		is3D: true,
		slices: {3: {offset: 0.3},},
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartCltIpTop"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?cltIp=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}

// Draw cltIp block chart.
google.setOnLoadCallback(drawCltIpBlock);
function drawCltIpBlock() {
	var data = google.visualization.arrayToDataTable([
		["IP", "Block"]
<%
arrList = cltIpTop.getDataListBlocked();
for(int i = 0; i < arrList.size(); i++){
	String[] arr = arrList.get(i);

	printf(", ['%s', %s]", arr[0], arr[1]);
}
%>
	]);

	var options = {
		title: "BLOCK TOP 5 CLIENT IPS",
		is3D: true,
	};

	var chart = new google.visualization.PieChart(document.getElementById("chartCltIpBlock"));

	// Link to request search result.
	function selectHandler() {
		var selectedItem = chart.getSelection()[0];
		if (selectedItem != null) {
			var value = data.getValue(selectedItem.row, 0);
			location.href = "logging,request.jsp?blockFlag=on&cltIp=" + value
				+ "&user=<%= gUser%>&stime=<%= gPieStime%>&etime=<%= gPieEtime%>";
		}
	}
	google.visualization.events.addListener(chart, "select", selectHandler);

	chart.draw(data, options);
}
</script>
<!-- /Google chart -->

<!-- view -->
<form action="<%= getPageName()%>" method="get">

<fieldset>
	<legend>WEEKLY REPORT</legend>
<table class="view">

	<tr>
		<td width="100" align="right">
	Report from :
		</td>
		<td>
			<input id="stime" type="text" value="<%= dao.getStime()%>" name="stime" size="8" onchange="javascript:setUserdef(this.form)">

			<div style="display: none;">
				<input type="radio" class="no-border" name="timeOption" value="userdef" onclick="javascript:setPeriod(this.form)"
					<%if(gTimeOption.equals("userdef")){out.print("checked");}%>> User defined
			</div>

			<input type="radio" class="no-border" name="timeOption" value="last7days" onclick="javascript:setPeriod(this.form)"
				<%if(gTimeOption.equals("last7days")){out.print("checked");}%>> Last 7 days
			<input type="radio" class="no-border" name="timeOption" value="1week" onclick="javascript:setPeriod(this.form)"
				<%if(gTimeOption.equals("1week")){out.print("checked");}%>> 1 week ago
			<input type="radio" class="no-border" name="timeOption" value="2weeks" onclick="javascript:setPeriod(this.form)"
				<%if(gTimeOption.equals("2weeks")){out.print("checked");}%>> 2 weeks ago
			<input type="radio" class="no-border" name="timeOption" value="3weeks" onclick="javascript:setPeriod(this.form)"
				<%if(gTimeOption.equals("3weeks")){out.print("checked");}%>> 3 weeks ago
		</td>
	</tr>

	<tr>
		<td width="100" align="right">
	User :
		</td>
		<td>
			<input type="text" value="<%= gUser%>" name="user" size="25">
			<select onchange="javascript:this.form.user.value=this.value">
			<option value=""> SELECT USER
<%
List<String> userList = dao.getLogUserList();
for(String uname : userList){
	printf("<option value='%s'>%s", uname, uname);
}
%>
			</select>
		</td>

	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:setPeriod2(this.form);this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<div class="title">
<%= dao.getStime()%> ~ <%= dao.getEtime()%>
<%
if(!isEmpty(gUser)){
	out.print(", " + gUser);
}
%>
</div>
<div class="stats">
request-sum = <%= stats.reqSum%>,
request-cnt = <%= stats.reqCnt%>,
block-sum = <%= stats.blockSum%>,
block-cnt = <%= stats.blockCnt%>,
domain = <%= stats.domainCnt%>,
user = <%= stats.userCnt%>,
client-ip = <%= stats.cltIpCnt%>
</div>

<table width="100%" cellpadding="0" cellspacing="0">
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td width="675">
		<div id="chartRequestTrend" class="chart"></div>
	</td>
	<td width="675">
		<div id="chartBlockTrend" class="chart"></div>
	</td>

	<td>
	</td>
</tr>
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td>
		<div id="chartDomainTop" class="chart"></div>
	</td>
	<td>
		<div id="chartDomainBlock" class="chart"></div>
	</td>

	<td>
	</td>
</tr>
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td>
		<div id="chartCategoryTop" class="chart"></div>
	</td>
	<td>
		<div id="chartCategoryBlock" class="chart"></div>
	</td>

	<td>
	</td>
</tr>

<%if(isEmpty(gUser)){%>
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td>
		<div id="chartUserTop" class="chart"></div>
	</td>
	<td>
		<div id="chartUserBlock" class="chart"></div>
	</td>

	<td>
	</td>
</tr>
<tr class="line"><td colspan="3"></td></tr>

<tr>
	<td>
		<div id="chartCltIpTop" class="chart"></div>
	</td>
	<td>
		<div id="chartCltIpBlock" class="chart"></div>
	</td>

	<td>
	</td>
</tr>
<%}%>

</table>

<%@include file="include/footer.jsp"%>

<!-- Datetime picker -->
<script type="text/javascript">
//-----------------------------------------------
var dateToDisable = new Date();
dateToDisable.setDate(dateToDisable.getDate() - 6);

//-----------------------------------------------
jQuery("#stime").datetimepicker({
	timepicker: false,
	format: "<%= getGuiDateFormatForPicker()%>",
	beforeShowDay: function(date) {
		if (date.getTime() > dateToDisable.getTime()) {
			return [false, ""]
		}

		return [true, ""];
	}
});
</script>
