<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(AllowedIpDao dao){
	if(demoFlag){
		errList.add("Not allowed on demo site.");
		return;
	}

	AllowedIpData oldData = dao.selectOne();

	AllowedIpData data = new AllowedIpData();
	data.dnsAllowed = paramString("dnsAllowed");
	data.dnsBlocked = paramString("dnsBlocked");
	//data.loginAllowed = paramString("loginAllowed");
	data.guiAllowed = paramString("guiAllowed");
	data.bypassAll = paramString("bypassAll");

	if(oldData.dnsAllowed.length() < data.dnsAllowed.length()){
		errList.add("'Allowed IP for DNS' has been deprecated. Use 'DNS > Access Control' instead.");
		return;
	}

	if(oldData.dnsBlocked.length() < data.dnsBlocked.length()){
		errList.add("'Blocked IP for DNS' has been deprecated. Use 'DNS > Access Control' instead.");
		return;
	}

	if(oldData.bypassAll.length() < data.bypassAll.length()){
		errList.add("'Bypass All' has been deprecated. Use 'DNS > Access Control' instead.");
		return;
	}

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
AllowedIpDao dao = new AllowedIpDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
AllowedIpData data = dao.selectOne();

if(isEmpty(actionFlag)){
	warnList.add("This is only for GUI access control. Access control for DNS has been moved into 'DNS > Access Control'.");
}
%>
<%@include file="include/action_info.jsp"%>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="update">

<fieldset>
<legend>ALLOWED IP</legend>
<table width="100%" class="view">

	<tr>
		<td colspan="2">
			<div style="line-height:20px;">
				This is an IP based access control. You can add IP addresses in the following format.
			</div>

				<div class="tab">
					ex) 192.168.1 - IP addresses which start with '192.168.1'<br>
				</div>
				</p>

			* You can add multiple IP addresses separated by spaces or newlines.<br>
				<div class="tab">
					ex) 192.168.1 192.168.2<br>
					192.168.3
				</div>
				</p>

			* For exact matching add a tailing dot.<br>
				<div class="tab">
					ex) 192.168.0.100. 192.168.0.200.
				</div>

		</td>
	</tr>

	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>

	<tr>
		<td width="220" valign="top">
			Allowed IP for DNS
			<i class="fa fa-question-circle south-east" title="Deprecated."></i>
		</td>
		<td>
			<textarea name="dnsAllowed" cols="80" rows="6"><%= data.dnsAllowed%></textarea>
		</td>
	</tr>

	<tr>
		<td valign="top">
			Blocked IP for DNS
			<i class="fa fa-question-circle south-east" title="Deprecated."></i>
		</td>
		<td>
			<textarea name="dnsBlocked" cols="80" rows="6"><%= data.dnsBlocked%></textarea>
		</td>
	</tr>

	<tr>
		<td valign="top">
			Allowed IP to GUI
			<i class="fa fa-question-circle south-east" title="'localhost' or '127.0.0.1' always allowed for accessing admin GUI."></i>
		</td>
		<td>
			<textarea name="guiAllowed" cols="80" rows="6"><%= data.guiAllowed%></textarea>
		</td>
	</tr>

	<tr>
		<td valign="top">
			Bypass All
			<i class="fa fa-question-circle south-east" title="Deprecated."></i>
		</td>
		<td>
			<textarea name="bypassAll" cols="80" rows="6"><%= data.bypassAll%></textarea>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

</form>
<!-- /view -->

<%@include file="include/footer.jsp"%>
