/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.DhcpReservedIpData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import nxd.lib.f;

public class DhcpReservedIpDao
extends FirstDao {
    public int selectCount() {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from dhcp_reserved_ip";
        int n2 = b2.f(string);
        b2.close();
        return n2;
    }

    protected DhcpReservedIpData a(RowSet rowSet) {
        DhcpReservedIpData dhcpReservedIpData = new DhcpReservedIpData();
        dhcpReservedIpData.id = rowSet.getInt("id");
        dhcpReservedIpData.ip = rowSet.getString("ip");
        dhcpReservedIpData.mac = rowSet.getString("mac");
        dhcpReservedIpData.description = rowSet.getString("description");
        return dhcpReservedIpData;
    }

    public List<DhcpReservedIpData> selectList() {
        b b2 = DaoUtil.getDbConfig();
        ArrayList<DhcpReservedIpData> arrayList = new ArrayList<DhcpReservedIpData>();
        String string = "select * from dhcp_reserved_ip order by id desc";
        RowSet rowSet = b2.l(string);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public DhcpReservedIpData selectOne(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from dhcp_reserved_ip where id = ?";
        RowSet rowSet = b2.m(string, new Object[]{n2});
        if (rowSet == null) {
            b2.close();
            return null;
        }
        DhcpReservedIpData dhcpReservedIpData = this.a(rowSet);
        rowSet.close();
        b2.close();
        return dhcpReservedIpData;
    }

    public boolean delete(int n2) {
        DhcpReservedIpData dhcpReservedIpData = this.selectOne(n2);
        if (dhcpReservedIpData == null) {
            this.d.error("DhcpReservedDao.delete, No such data!");
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "delete from dhcp_reserved_ip where id = ?";
        boolean bl = b2.d(string, new Object[]{n2});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("dhcp_reserved_ip");
        return true;
    }

    private boolean a(DhcpReservedIpData dhcpReservedIpData) {
        if (nxd.lib.c.a(dhcpReservedIpData.ip)) {
            this.d.error("DhcpReservedIpDao.checkParam, IP address missing!");
            return false;
        }
        if (nxd.lib.c.a(dhcpReservedIpData.mac)) {
            this.d.error("DhcpReservedIpDao.checkParam, MAC address missing!");
            return false;
        }
        if (!f.b(dhcpReservedIpData.ip)) {
            this.d.error("DhcpReservedIpDao.checkParam, Invalid IP!");
            return false;
        }
        if (!ParamTest.isValidMac(dhcpReservedIpData.mac)) {
            this.d.error("DhcpReservedIpDao.checkParam, Invalid MAC address!");
            return false;
        }
        if (ParamTest.isDupDhcpReservedIp(dhcpReservedIpData.ip, dhcpReservedIpData.mac)) {
            this.d.error("DhcpReservedIpDao.checkParam, IP or MAC already exists!");
            return false;
        }
        if (ParamTest.isDhcpReservedIpOutOfRange(dhcpReservedIpData.ip)) {
            this.d.error("IpPool.addReservedIp, IP is out of range.");
            return false;
        }
        return true;
    }

    public boolean insert(DhcpReservedIpData dhcpReservedIpData) {
        dhcpReservedIpData.sanitize();
        if (!this.a(dhcpReservedIpData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into dhcp_reserved_ip(ip, mac, description) values(?, ?, ?)";
        boolean bl = b2.d(string, new Object[]{dhcpReservedIpData.ip, dhcpReservedIpData.mac, dhcpReservedIpData.description});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("dhcp_reserved_ip");
        return true;
    }
}

