/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.DnsSetupData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;
import org.xbill.DNS.DohResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class DnsSetupDao
extends FirstDao {
    private boolean a(DnsSetupData dnsSetupData) {
        if (!ParamTest.isValidUpstreamDnsServer(dnsSetupData.upstreamDns1)) {
            this.d.error("DSDcP, Invalid IP address for Upstream DNS server #1!");
            return false;
        }
        if (nxd.lib.c.b(dnsSetupData.upstreamDns2) && !ParamTest.isValidUpstreamDnsServer(dnsSetupData.upstreamDns2)) {
            this.d.error("DSDcP, Invalid IP address for Upstream DNS server #2!");
            return false;
        }
        if (nxd.lib.c.b(dnsSetupData.upstreamDns3) && !ParamTest.isValidUpstreamDnsServer(dnsSetupData.upstreamDns3)) {
            this.d.error("DSDcP, Invalid IP address for Upstream DNS server #3!");
            return false;
        }
        return true;
    }

    public DnsSetupData selectOne() {
        DnsSetupData dnsSetupData = new DnsSetupData();
        b b2 = DaoUtil.getDbConfig();
        String string = "select * from dns_setup";
        RowSet rowSet = b2.m(string);
        dnsSetupData.upstreamDns1 = rowSet.getString("upstream_dns1");
        dnsSetupData.upstreamDns2 = rowSet.getString("upstream_dns2");
        dnsSetupData.upstreamDns3 = rowSet.getString("upstream_dns3");
        dnsSetupData.upstreamTimeout = rowSet.getInt("upstream_timeout");
        dnsSetupData.upstreamLoadBalance = rowSet.str2bool("upstream_load_balance");
        dnsSetupData.respCacheSize = rowSet.getInt("resp_cache_size");
        dnsSetupData.usePersistentCache = rowSet.str2bool("use_persistent_cache");
        dnsSetupData.useNegativeCache = rowSet.str2bool("use_negative_cache");
        dnsSetupData.minimalResponses = rowSet.str2bool("minimal_responses");
        dnsSetupData.minCacheTtl = rowSet.getInt("min_cache_ttl");
        dnsSetupData.blockCacheTtl = rowSet.getInt("block_cache_ttl");
        dnsSetupData.localDns = rowSet.getString("local_dns");
        dnsSetupData.localDomain = rowSet.getString("local_domain");
        dnsSetupData.localTimeout = rowSet.getInt("local_timeout");
        dnsSetupData.localLoadBalance = rowSet.str2bool("local_load_balance");
        dnsSetupData.useLocalDns = rowSet.str2bool("use_local_dns");
        dnsSetupData.dynamicDnsDomain = rowSet.getString("dynamic_dns_domain");
        dnsSetupData.dynamicDnsTtl = rowSet.getInt("dynamic_dns_ttl");
        dnsSetupData.enableDynamicDns = rowSet.str2bool("enable_dynamic_dns");
        dnsSetupData.dropAttackRequestByDomain = rowSet.str2bool("drop_attack_request_by_domain");
        dnsSetupData.dropAttackRequestByIp = rowSet.str2bool("drop_attack_request_by_ip");
        dnsSetupData.dropHostnameWithoutDomain = rowSet.str2bool("drop_hostname_without_domain");
        dnsSetupData.dropPtrForPrivateIp = rowSet.str2bool("drop_ptr_for_private_ip");
        dnsSetupData.allowPtrForServerIp = rowSet.str2bool("allow_ptr_for_server_ip");
        dnsSetupData.httpsDnsType = rowSet.getInt("https_dns_type");
        dnsSetupData.httpsDnsTimeout = rowSet.getInt("https_dns_timeout");
        dnsSetupData.httpsDnsUrl = rowSet.getString("https_dns_url");
        dnsSetupData.failsafeWithUdp53 = rowSet.str2bool("failsafe_with_udp53");
        dnsSetupData.useHttpsDns = rowSet.str2bool("use_https_dns");
        dnsSetupData.allowedRequestType = rowSet.getString("allowed_request_type");
        dnsSetupData.blockedRequestType = rowSet.getString("blocked_request_type");
        rowSet.close();
        b2.close();
        String string2 = this.c.f();
        if (string2 == null) {
            this.d.error("DnsSetup.selectOne, Local TCP connection failed!");
            return dnsSetupData;
        }
        String[] stringArray = string2.split("\\|");
        if (stringArray.length >= 3) {
            dnsSetupData.inMemoryCacheSize = nxd.lib.c.d(stringArray[0]);
            dnsSetupData.persistentCacheSize = nxd.lib.c.d(stringArray[1]);
            dnsSetupData.negativeCacheSize = nxd.lib.c.d(stringArray[2]);
        }
        return dnsSetupData;
    }

    public boolean update(DnsSetupData dnsSetupData) {
        dnsSetupData.sanitize();
        if (!this.a(dnsSetupData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "update dns_setup set";
        string = string + " upstream_dns1 = ?, upstream_dns2 = ?, upstream_dns3 = ?, upstream_timeout = ?, upstream_load_balance = ?";
        string = string + ", resp_cache_size = ?, use_persistent_cache = ?, use_negative_cache = ?, minimal_responses = ?";
        string = string + ", dynamic_dns_domain = ?, dynamic_dns_ttl = ?, enable_dynamic_dns = ?";
        string = string + ", local_dns = ?, local_domain = ?, local_timeout = ?, local_load_balance = ?, use_local_dns = ?";
        string = string + ", drop_attack_request_by_domain = ?, drop_attack_request_by_ip = ?";
        string = string + ", drop_hostname_without_domain = ?, drop_ptr_for_private_ip = ?, allow_ptr_for_server_ip = ?";
        string = string + ", https_dns_type = ?, https_dns_timeout = ?, https_dns_url = ?, failsafe_with_udp53 = ?, use_https_dns = ?";
        string = string + ", min_cache_ttl = ?, block_cache_ttl = ?, allowed_request_type = ?, blocked_request_type = ?";
        boolean bl = b2.d(string, new Object[]{dnsSetupData.upstreamDns1, dnsSetupData.upstreamDns2, dnsSetupData.upstreamDns3, dnsSetupData.upstreamTimeout, nxd.lib.c.d(dnsSetupData.upstreamLoadBalance), dnsSetupData.respCacheSize, dnsSetupData.usePersistentCache, dnsSetupData.useNegativeCache, dnsSetupData.minimalResponses, dnsSetupData.dynamicDnsDomain, dnsSetupData.dynamicDnsTtl, nxd.lib.c.d(dnsSetupData.enableDynamicDns), dnsSetupData.localDns, dnsSetupData.localDomain, dnsSetupData.localTimeout, nxd.lib.c.d(dnsSetupData.localLoadBalance), nxd.lib.c.d(dnsSetupData.useLocalDns), nxd.lib.c.d(dnsSetupData.dropAttackRequestByDomain), nxd.lib.c.d(dnsSetupData.dropAttackRequestByIp), nxd.lib.c.d(dnsSetupData.dropHostnameWithoutDomain), nxd.lib.c.d(dnsSetupData.dropPtrForPrivateIp), nxd.lib.c.d(dnsSetupData.allowPtrForServerIp), dnsSetupData.httpsDnsType, dnsSetupData.httpsDnsTimeout, dnsSetupData.httpsDnsUrl, nxd.lib.c.d(dnsSetupData.failsafeWithUdp53), nxd.lib.c.d(dnsSetupData.useHttpsDns), dnsSetupData.minCacheTtl, dnsSetupData.blockCacheTtl, dnsSetupData.allowedRequestType, dnsSetupData.blockedRequestType});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("dns_setup");
        return true;
    }

    public boolean testDohServer(String string) {
        try {
            Record record = Record.newRecord((Name)Name.fromString((String)"google.com."), (int)1, (int)1);
            Message message2 = Message.newQuery((Record)record);
            DohResolver dohResolver = new DohResolver(string);
            dohResolver.setUsePost(true);
            dohResolver.setTimeout(2);
            dohResolver.sendAsync(message2).whenComplete((message, throwable) -> {
                if (throwable == null) {
                    this.d.info("DnsSetupDao.testDohServer, It worked. DoH server URL = {}", (Object)string);
                } else {
                    this.d.error("DnsSetupDao.testDohServer, " + throwable.toString());
                }
            }).toCompletableFuture().get();
        }
        catch (Exception exception) {
            this.d.error("DnsSetupDao.testDohServer, " + exception.toString());
            return false;
        }
        return true;
    }
}

