/*
 * Decompiled with CFR 0.152.
 */
package nxd.data;

import java.util.ArrayList;
import java.util.List;
import nxd.data.FirstData;
import nxd.data.GroupData;
import nxd.data.UserIpData;
import nxd.data.UserMacData;
import nxd.lib.c;
import nxd.lib.d;
import nxd.o.j;

public class UserData
extends FirstData {
    public int id = 0;
    public String name = "";
    public String description = "";
    public String passwd = "";
    public String token = "";
    public String expDate = "";
    public int policyId = 1;
    public int ftPolicyId = 0;
    public String policyName = "";
    public String ftPolicyName = "";
    public int ldapId = 0;
    public List<GroupData> groupList = new ArrayList<GroupData>();
    public List<UserIpData> ipList = new ArrayList<UserIpData>();
    public List<UserMacData> macList = new ArrayList<UserMacData>();
    public int grpId = 0;
    public boolean massFlag = false;
    public int pwchgCnt = 0;
    public String ctime = "";

    @Override
    public void sanitize() {
        this.name = c.a(this.name, 64);
        this.description = c.a(this.description, 100);
        this.token = this.token.toUpperCase();
        this.expDate = j.e(this.expDate);
        this.expDate = this.expDate.replaceAll("\\D", "");
        if (d.a("yyyyMMddHHmm", this.expDate) == 0) {
            this.expDate = "";
        }
        if (this.policyId == 0) {
            this.policyId = 1;
        }
    }

    public String getIpLine() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (UserIpData userIpData : this.ipList) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(userIpData.asString());
        }
        return stringBuilder.toString();
    }

    public String getMacLine() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (UserMacData userMacData : this.macList) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(userMacData.mac);
        }
        return stringBuilder.toString();
    }

    public String getGroupLine() {
        if (this.groupList.isEmpty()) {
            return "anon-grp";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (GroupData groupData : this.groupList) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(groupData.name);
        }
        return stringBuilder.toString();
    }

    public String getType() {
        String string = "";
        if (!this.ipList.isEmpty()) {
            string = "I";
        }
        if (this.passwd.length() > 0) {
            string = string + "P";
        }
        if (this.ldapId > 0) {
            string = string + "L";
        }
        if (this.expDate.length() > 0 && d.a("yyyyMMdd").compareTo(this.expDate) > 0) {
            string = "E";
        }
        return string;
    }

    public String getExpDateOld() {
        String string = "";
        if (!c.a(this.expDate)) {
            string = d.b("yyyyMMddHHmm", "yyyy/MM/dd HH:mm", this.expDate);
        }
        return string;
    }

    public String getExpDate() {
        return j.b(this.expDate);
    }

    public String getCtime() {
        return j.b(this.ctime);
    }
}

