/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.pool;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslog;
import org.productivity.java.syslog4j.impl.AbstractSyslogConfigIF;
import org.productivity.java.syslog4j.impl.AbstractSyslogWriter;

public abstract class AbstractSyslogPoolFactory
extends BasePoolableObjectFactory {
    private static final long serialVersionUID = -7441569603980981508L;
    protected AbstractSyslog syslog = null;
    protected AbstractSyslogConfigIF syslogConfig = null;
    protected ObjectPool pool = null;

    public void initialize(AbstractSyslog abstractSyslog) throws SyslogRuntimeException {
        this.syslog = abstractSyslog;
        try {
            this.syslogConfig = (AbstractSyslogConfigIF)this.syslog.getConfig();
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("config must implement AbstractSyslogConfigIF");
        }
        this.pool = this.createPool();
    }

    public Object makeObject() throws Exception {
        AbstractSyslogWriter abstractSyslogWriter = this.syslog.createWriter();
        if (this.syslogConfig.isThreaded()) {
            this.syslog.createWriterThread(abstractSyslogWriter);
        }
        return abstractSyslogWriter;
    }

    public void destroyObject(Object object) throws Exception {
        AbstractSyslogWriter abstractSyslogWriter = (AbstractSyslogWriter)object;
        abstractSyslogWriter.shutdown();
        super.destroyObject((Object)abstractSyslogWriter);
    }

    public abstract ObjectPool createPool() throws SyslogRuntimeException;

    public AbstractSyslogWriter borrowSyslogWriter() throws Exception {
        AbstractSyslogWriter abstractSyslogWriter = (AbstractSyslogWriter)this.pool.borrowObject();
        return abstractSyslogWriter;
    }

    public void returnSyslogWriter(AbstractSyslogWriter abstractSyslogWriter) throws Exception {
        this.pool.returnObject((Object)abstractSyslogWriter);
    }

    public void clear() throws Exception {
        this.pool.clear();
    }

    public void close() throws Exception {
        this.pool.close();
    }
}

