/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.net.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.impl.AbstractSyslogServer;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class UDPNetSyslogServer
extends AbstractSyslogServer {
    protected DatagramSocket ds = null;

    public void initialize() throws SyslogRuntimeException {
    }

    public void shutdown() {
        super.shutdown();
        if (this.syslogServerConfig.getShutdownWait() > 0L) {
            SyslogUtility.sleep(this.syslogServerConfig.getShutdownWait());
        }
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    protected DatagramSocket createDatagramSocket() throws SocketException, UnknownHostException {
        DatagramSocket datagramSocket = null;
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort(), inetAddress);
        } else {
            datagramSocket = new DatagramSocket(this.syslogServerConfig.getPort());
        }
        return datagramSocket;
    }

    public void run() {
        try {
            this.ds = this.createDatagramSocket();
            this.shutdown = false;
        }
        catch (SocketException socketException) {
            return;
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        byte[] byArray = new byte[1024];
        UDPNetSyslogServer.handleInitialize(this);
        while (!this.shutdown) {
            DatagramPacket datagramPacket = null;
            try {
                datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.ds.receive(datagramPacket);
                SyslogServerEventIF syslogServerEventIF = UDPNetSyslogServer.createEvent(this.getConfig(), byArray, datagramPacket.getLength(), datagramPacket.getAddress());
                UDPNetSyslogServer.handleEvent(null, (SyslogServerIF)this, datagramPacket, syslogServerEventIF);
            }
            catch (SocketException socketException) {
                int n = socketException.getMessage() == null ? -1 : socketException.getMessage().toLowerCase().indexOf("socket closed");
                if (n != -1) continue;
                UDPNetSyslogServer.handleException(null, this, datagramPacket.getSocketAddress(), socketException);
            }
            catch (IOException iOException) {
                UDPNetSyslogServer.handleException(null, this, datagramPacket.getSocketAddress(), iOException);
            }
        }
        UDPNetSyslogServer.handleDestroy(this);
    }
}

