/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.dictionary;

import java.util.HashMap;
import java.util.Map;
import org.tinyradius.attribute.RadiusAttribute;

public class AttributeType {
    private int vendorId = -1;
    private int typeCode;
    private String name;
    private Class attributeClass;
    private Map enumeration = null;

    public AttributeType(int code, String name, Class type) {
        this.setTypeCode(code);
        this.setName(name);
        this.setAttributeClass(type);
    }

    public AttributeType(int vendor, int code, String name, Class type) {
        this.setTypeCode(code);
        this.setName(name);
        this.setAttributeClass(type);
        this.setVendorId(vendor);
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public void setTypeCode(int code) {
        if (code < 1 || code > 255) {
            throw new IllegalArgumentException("code out of bounds");
        }
        this.typeCode = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        this.name = name;
    }

    public Class getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!RadiusAttribute.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("type is not a RadiusAttribute descendant");
        }
        this.attributeClass = type;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(int vendorId) {
        this.vendorId = vendorId;
    }

    public String getEnumeration(int value) {
        if (this.enumeration != null) {
            return (String)this.enumeration.get(new Integer(value));
        }
        return null;
    }

    public Integer getEnumeration(String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("value is empty");
        }
        if (this.enumeration == null) {
            return null;
        }
        for (Map.Entry e : this.enumeration.entrySet()) {
            if (!e.getValue().equals(value)) continue;
            return (Integer)e.getKey();
        }
        return null;
    }

    public void addEnumerationValue(int num, String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
        if (this.enumeration == null) {
            this.enumeration = new HashMap();
        }
        this.enumeration.put(new Integer(num), name);
    }

    public String toString() {
        String s = this.getTypeCode() + "/" + this.getName() + ": " + this.attributeClass.getName();
        if (this.getVendorId() != -1) {
            s = s + " (vendor " + this.getVendorId() + ")";
        }
        return s;
    }
}

