<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(WhitelistDomainDao dao){
	WhitelistData data = new WhitelistData();
	data.id = paramInt("id");
	data.description = paramString("description");

	data.bypassAuth = paramBoolean("bypassAuth");
	data.bypassFilter = paramBoolean("bypassFilter");
	data.bypassLog = paramBoolean("bypassLog");
	data.adminBlock = paramBoolean("adminBlock");
	data.dropPacket = paramBoolean("dropPacket");
	data.appliedPolicyArr = paramArray("appliedPolicyArr");

	if((data.bypassAuth || data.dropPacket)
		&& (data.appliedPolicyArr != null && data.appliedPolicyArr.length > 0)){

		errList.add("'Bypass Authetication' and 'Drop Packet' should be applied on global level.");
		return;
	}

	if(dao.update(data)){
		succList.add("Data updated.");
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Check refresh without id.
if(!checkEditId("whitelist,domain.jsp")){
	return;
}

// Create data access object.
WhitelistDomainDao dao = new WhitelistDomainDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}

// Global.
WhitelistData data = dao.selectOne(paramInt("id"));

// Get policy list.
PolicyDao polDao = new PolicyDao();
Map<Integer, String> policyIdNameMap = dao.getPolicyIdNameMap();
%>
<%@include file="include/action_info.jsp"%>
<script type="text/javascript">
//-----------------------------------------------
function actionUpdate(form){
	form.actionFlag.value = "update";
	form.submit();
}
</script>

<!-- view -->
<form action="<%= getPageName()%>" method="post">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="<%= data.id%>">

<!--  -->
<fieldset>
	<legend>WHITELIST BY DOMAIN</legend>
<table class="view">

	<tr>
		<td width="200">Domain</td>
		<td><%= data.domain%></td>
	</tr>

	<tr>
		<td>Description</td>
		<td>
		<input type="text" name="description" value="<%= data.description%>" size="50">
		</td>
	</tr>

	<tr>
		<td>Bypass Authentication</td>
		<td>
			<input type="checkbox" class="no-border" name="bypassAuth" <%if(data.bypassAuth){out.print("checked");}%>>
		</td>
	</tr>

	<tr>
		<td>Bypass Filtering</td>
		<td>
			<input type="checkbox" class="no-border" name="bypassFilter" <%if(data.bypassFilter){out.print("checked");}%>>
		</td>
	</tr>

	<tr>
		<td>Bypass Logging</td>
		<td>
			<input type="checkbox" class="no-border" name="bypassLog" <%if(data.bypassLog){out.print("checked");}%>>
		</td>
	</tr>

	<tr>
		<td>Admin Block</td>
		<td>
			<input type="checkbox" class="no-border" name="adminBlock" <%if(data.adminBlock){out.print("checked");}%>>
		</td>
	</tr>

	<tr>
		<td>Drop Packet</td>
		<td>
			<input type="checkbox" class="no-border" name="dropPacket" <%if(data.dropPacket){out.print("checked");}%>>
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:actionUpdate(this.form)">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>

<!--  -->
<fieldset>
	<legend>APPLIED POLICY</legend>
<table class="view">

	<tr>
		<td valign="top">
			Applied Policy
			<i class="fa fa-question-circle south-east" title="If there's no applied policy it becomes a global whitelist."></i>
		</td>
		<td>
<%
int i = 0;
for(Map.Entry<Integer, String> e: policyIdNameMap.entrySet()){
	int policyId = e.getKey();
	String policyName = e.getValue();

	String chkLine = "";
	if(data.isAppliedPolicy(policyId)){
		chkLine = "checked";	
	}

	if(i > 0 && i % 5 == 0){
		out.println("<br>");
	}
%>
			<span class="category-item">
				<input type="checkbox" class="no-border"
					name="appliedPolicyArr" value="<%= policyId%>" <%= chkLine%>><%= policyName%>
			</span>
<%
	i++;
}
%>
		</td>
	</tr>

	<tr>
		<td width="200"></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:actionUpdate(this.form)">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<%@include file="include/footer.jsp"%>
