/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.util.RadiusException;

public class Ipv6PrefixAttribute
extends RadiusAttribute {
    public Ipv6PrefixAttribute() {
    }

    public Ipv6PrefixAttribute(int type, String value) {
        this.setAttributeType(type);
        this.setAttributeValue(value);
    }

    public String getAttributeValue() {
        byte[] data = this.getAttributeData();
        if (data == null || data.length != 18) {
            throw new RuntimeException("ip attribute: expected 18 bytes attribute data");
        }
        try {
            int prefix = data[1] & 0xFF;
            Inet6Address addr = (Inet6Address)Inet6Address.getByAddress(null, Arrays.copyOfRange(data, 2, data.length));
            return addr.getHostAddress() + "/" + prefix;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("bad IPv6 prefix", e);
        }
    }

    public void setAttributeValue(String value) {
        if (value == null || value.length() < 3) {
            throw new IllegalArgumentException("bad IPv6 address : " + value);
        }
        try {
            byte[] data = new byte[18];
            data[0] = 0;
            int slashPos = value.indexOf("/");
            data[1] = (byte)(Integer.valueOf(value.substring(slashPos + 1)) & 0xFF);
            Inet6Address addr = (Inet6Address)Inet6Address.getByName(value.substring(0, slashPos));
            byte[] ipData = addr.getAddress();
            for (int i = 0; i < ipData.length; ++i) {
                data[i + 2] = ipData[i];
            }
            this.setAttributeData(data);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("bad IPv6 address : " + value, e);
        }
    }

    public void readAttribute(byte[] data, int offset, int length) throws RadiusException {
        if (length != 20) {
            throw new RadiusException("IP attribute: expected 18 bytes data");
        }
        super.readAttribute(data, offset, length);
    }
}

