/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nxd.dao.DaoUtil;
import nxd.dao.FirstDao;
import nxd.dao.ParamTest;
import nxd.data.GroupData;
import nxd.data.GroupUserRelationData;
import nxd.data.UserData;
import nxd.lib.RowSet;
import nxd.lib.b;
import nxd.lib.c;

public class GroupDao
extends FirstDao {
    private Map<Integer, String> a = null;

    private String a() {
        String string = this.searchOption.toSql(12);
        if (nxd.lib.c.a(string)) {
            return "";
        }
        return " where " + string;
    }

    public void addKw(String string) {
        if (this.searchOption.size() > 0) {
            return;
        }
        this.searchOption.addKw("name", string, 2);
        this.searchOption.addKw("description", string, 2);
    }

    public int selectCount() {
        String string = this.a();
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from grp" + string);
        b2.close();
        return n2;
    }

    private boolean a(int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from grp where id = ? and ldap_id > 0", new Object[]{n2});
        b2.close();
        return n3 > 0;
    }

    private List<GroupData> b(int n2) {
        ArrayList<GroupData> arrayList = new ArrayList<GroupData>();
        b b2 = DaoUtil.getDbConfig();
        String string = "select a.id id, a.name name from grp a, grp_grp b";
        string = string + " where a.id = b.child_id and parent_id = ? order by lower(a.name)";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            GroupData groupData = new GroupData();
            groupData.id = rowSet.getInt("id");
            groupData.name = rowSet.getString("name");
            arrayList.add(groupData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private List<GroupUserRelationData> c(int n2) {
        b b2 = DaoUtil.getDbConfig();
        ArrayList<GroupUserRelationData> arrayList = new ArrayList<GroupUserRelationData>();
        String string = "select * from (";
        string = string + "select id, name, '' grp from user where ldap_id = 0 and id not in (select user_id from user_grp)";
        string = string + " union";
        string = string + " select a.id id, a.name name, b.name grp";
        string = string + " from user a, grp b, user_grp c";
        string = string + " where a.id = c.user_id and b.id = c.grp_id";
        string = string + " and a.ldap_id = 0 and b.ldap_id = 0";
        string = string + ")";
        string = string + " where id not in (select user_id from user_grp where grp_id = ?) order by lower(name)";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            GroupUserRelationData groupUserRelationData = new GroupUserRelationData();
            groupUserRelationData.userId = rowSet.getInt("id");
            groupUserRelationData.groupId = n2;
            groupUserRelationData.userName = rowSet.getString("name");
            groupUserRelationData.groupName = rowSet.getString("grp");
            arrayList.add(groupUserRelationData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private List<UserData> d(int n2) {
        b b2 = DaoUtil.getDbConfig();
        ArrayList<UserData> arrayList = new ArrayList<UserData>();
        String string = "select * from user where id in(select";
        string = string + " user_id from user_grp where grp_id = ?) order by lower(name)";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            UserData userData = new UserData();
            userData.id = rowSet.getInt("id");
            userData.name = rowSet.getString("name");
            arrayList.add(userData);
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    private String[] e(int n2) {
        b b2 = DaoUtil.getDbConfig();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "select * from user where id in(select";
        string = string + " user_id from user_grp where grp_id = ?) order by lower(name)";
        RowSet rowSet = b2.l(string, new Object[]{n2});
        while (rowSet.next()) {
            String string2 = rowSet.getString("id");
            arrayList.add(string2);
        }
        rowSet.close();
        b2.close();
        return arrayList.toArray(new String[0]);
    }

    private boolean a(GroupData groupData) {
        if (!ParamTest.isValidNameLen(groupData.name)) {
            this.d.error("GDcP, {}", (Object)ParamTest.ERR_NAME_LEN);
            return false;
        }
        if (!ParamTest.isValidGrpnameChar(groupData.name)) {
            this.d.error("GDcP, {}", (Object)"Only alphabet, number, [-_] allowed in group name.");
            return false;
        }
        if (ParamTest.isDupGroup(groupData.name)) {
            this.d.error("GDcP, Group already exists!");
            return false;
        }
        return true;
    }

    public boolean insert(GroupData groupData) {
        groupData.sanitize();
        if (!this.a(groupData)) {
            return false;
        }
        b b2 = DaoUtil.getDbConfig();
        String string = "insert into grp(name, description) values(?, ?)";
        boolean bl = b2.d(string, new Object[]{groupData.name, groupData.description});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("grp");
        return true;
    }

    private boolean a(int n2, String string) {
        int n3;
        String[] stringArray;
        String[] stringArray2 = new String[]{};
        if (string.length() > 0) {
            stringArray2 = string.split(",");
        }
        String[] stringArray3 = this.e(n2);
        b b2 = DaoUtil.getDbConfig();
        String[] stringArray4 = stringArray = nxd.lib.c.b(stringArray3, stringArray2);
        int n4 = stringArray4.length;
        for (n3 = 0; n3 < n4; ++n3) {
            String string2 = stringArray4[n3];
            String string3 = "delete from user_grp where user_id = ? and grp_id = ?";
            b2.b(string3, new Object[]{string2, n2});
        }
        for (String string3 : stringArray4 = nxd.lib.c.b(stringArray2, stringArray3)) {
            String string4 = "insert into user_grp(user_id, grp_id) values(?, ?)";
            b2.b(string4, new Object[]{string3, n2});
        }
        String string7 = "delete from user_grp where user_id in(";
        string7 = string7 + "select user_id from user_grp where grp_id = ?";
        string7 = string7 + ") and grp_id <> ?";
        n3 = b2.d(string7, new Object[]{n2, n2}) ? 1 : 0;
        if (n3 == 0) {
            this.d.error("DB error!");
            return false;
        }
        return true;
    }

    public boolean update(GroupData groupData) {
        groupData.sanitize();
        b b2 = DaoUtil.getDbConfig();
        String string = "update grp set description = ?, policy_id = ?, ft_policy_id = ?, ft_stime = ?, ft_etime = ? where id = ?";
        boolean bl = b2.d(string, new Object[]{groupData.description, groupData.policyId, groupData.ftPolicyId, groupData.ftStime, groupData.ftEtime, groupData.id});
        if (!bl) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("grp");
        this.c.b("user");
        return true;
    }

    public boolean moveUser(int n2, String string) {
        if (this.a(n2)) {
            this.d.error("GDmU, LDAP imported group!");
            return false;
        }
        if (!this.a(n2, string)) {
            return false;
        }
        this.c.b("user");
        return true;
    }

    public boolean addUser(int n2, String[] stringArray) {
        if (this.a(n2)) {
            this.d.error("GroupDao.addUser, LDAP imported group!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            for (String string : stringArray) {
                String string2 = "select count(*) from user_grp where user_id = ? and grp_id = ?";
                if (b2.f(string2, new Object[]{string, n2}) > 0) continue;
                string2 = "insert into user_grp(user_id, grp_id) values(?, ?)";
                b2.b(string2, new Object[]{string, n2});
            }
        }
        this.c.b("user");
        return true;
    }

    public boolean delUser(int n2, int n3) {
        if (this.a(n2)) {
            this.d.error("GroupDao.delMember, LDAP imported group!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from user_grp where user_id = ? and grp_id = ?";
            b2.b(string, new Object[]{n3, n2});
        }
        this.c.b("user");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int n2) {
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from user_grp where grp_id = ?";
            b2.c(string, new Object[]{n2});
            string = "delete from grp_grp where child_id = ? or parent_id = ?";
            b2.c(string, new Object[]{n2, n2});
            string = "delete from grp where id = ?";
            b2.c(string, new Object[]{n2});
        }
        if (!DaoUtil.deleteOrphan()) {
            this.d.error("DB error!");
            return false;
        }
        this.c.b("grp");
        return true;
    }

    private GroupData a(RowSet rowSet, boolean bl) {
        if (this.a == null) {
            this.a = DaoUtil.getPolicyIdNameMap();
        }
        GroupData groupData = new GroupData();
        groupData.id = rowSet.getInt("id");
        groupData.name = rowSet.getString("name");
        groupData.description = rowSet.getString("description");
        groupData.policyId = rowSet.getInt("policy_id");
        groupData.ftPolicyId = rowSet.getInt("ft_policy_id");
        groupData.ldapId = rowSet.getInt("ldap_id");
        groupData.ftStime = rowSet.getString("ft_stime");
        groupData.ftEtime = rowSet.getString("ft_etime");
        groupData.ctime = rowSet.getString("ctime");
        groupData.policyName = nxd.lib.c.a((Object)this.a.get(groupData.policyId));
        groupData.ftPolicyName = nxd.lib.c.a((Object)this.a.get(groupData.ftPolicyId));
        groupData.groupList = this.b(groupData.id);
        if (bl) {
            return groupData;
        }
        groupData.userList = this.d(groupData.id);
        groupData.groupUserRelationList = this.c(groupData.id);
        return groupData;
    }

    private GroupData a(String string, Object[] objectArray) {
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.m(string, objectArray);
        if (rowSet == null) {
            b2.close();
            return null;
        }
        GroupData groupData = this.a(rowSet, false);
        rowSet.close();
        b2.close();
        return groupData;
    }

    public GroupData selectOne(int n2) {
        String string = "select * from grp where id = ?";
        return this.a(string, new Object[]{n2});
    }

    public GroupData selectOneByName(String string) {
        String string2 = "select * from grp where name = ?";
        return this.a(string2, new Object[]{string});
    }

    public List<GroupData> selectList() {
        String string = this.a();
        int n2 = nxd.lib.c.a(this.limit, this.page);
        ArrayList<GroupData> arrayList = new ArrayList<GroupData>();
        String string2 = "select * from grp" + string;
        string2 = string2 + String.format(" order by lower(name) limit %s, %s", n2, this.limit);
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string2);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet, false));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public List<GroupData> selectListUserCreatedOnly() {
        ArrayList<GroupData> arrayList = new ArrayList<GroupData>();
        String string = "select * from grp where ldap_id = 0";
        b b2 = DaoUtil.getDbConfig();
        RowSet rowSet = b2.l(string);
        while (rowSet.next()) {
            arrayList.add(this.a(rowSet, true));
        }
        rowSet.close();
        b2.close();
        return arrayList;
    }

    public List<String> selectListGname() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "select name from grp order by name limit 1000";
            RowSet rowSet = b2.l(string);
            while (rowSet.next()) {
                arrayList.add(rowSet.getString(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static List<UserData> getAvailUsers(int n2) {
        ArrayList<UserData> arrayList = new ArrayList<UserData>();
        String string = "select id, name from user where ldap_id = 0";
        string = string + "and id not in(";
        string = string + "  select user_id from user_grp where grp_id = ?";
        string = string + ") order by lower(name)";
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.l(string, new Object[]{n2});){
            while (rowSet.next()) {
                int n3 = rowSet.getInt("id");
                String string2 = rowSet.getString("name");
                UserData userData = new UserData();
                userData.id = n3;
                userData.name = string2;
                arrayList.add(userData);
            }
        }
        return arrayList;
    }

    private boolean a(int n2, String[] stringArray) {
        GroupData groupData = this.selectOne(n2);
        if (groupData.ldapId > 0) {
            this.d.error("GroupDao.addGroup, LDAP imported group!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            for (String string : stringArray) {
                if (n2 == nxd.lib.c.d(string)) continue;
                String string2 = "select count(*) from grp_grp where child_id = ? and parent_id = ?";
                if (b2.f(string2, new Object[]{n2, string}) > 0) continue;
                string2 = "insert into grp_grp(child_id, parent_id) values(?, ?)";
                b2.b(string2, new Object[]{n2, string});
            }
        }
        this.c.b("grp");
        return true;
    }

    private boolean a(int n2, int n3) {
        GroupData groupData = this.selectOne(n2);
        if (groupData.ldapId > 0) {
            this.d.error("UserDao.delGroup, LDAP imported group!");
            return false;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            String string = "delete from grp_grp where child_id = ? and parent_id = ?";
            b2.b(string, new Object[]{n2, n3});
        }
        this.c.b("grp");
        return true;
    }

    public static List<GroupData> getAvailGroups(int n2) {
        ArrayList<GroupData> arrayList = new ArrayList<GroupData>();
        String string = "select id, name from grp where ldap_id = 0";
        string = string + "and id not in(";
        string = string + "  select parent_id from grp_grp where child_id = ?";
        string = string + ") order by lower(name)";
        try (b b2 = DaoUtil.getDbConfig();
             RowSet rowSet = b2.l(string, new Object[]{n2});){
            while (rowSet.next()) {
                int n3 = rowSet.getInt("id");
                String string2 = rowSet.getString("name");
                if (n3 == n2) continue;
                GroupData groupData = new GroupData();
                groupData.id = n3;
                groupData.name = string2;
                arrayList.add(groupData);
            }
        }
        return arrayList;
    }
}

