/*
 * Decompiled with CFR 0.152.
 */
package nxd.dao;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nxd.dao.DaoUtil;
import nxd.e.f;
import nxd.lib.b;
import nxd.lib.c;

public class ParamTest {
    public static final int MIN_NAME_LEN = 1;
    public static final int MAX_NAME_LEN = 64;
    public static final int MIN_PASSWD_LEN = 1;
    public static final int MAX_PASSWD_LEN = 128;
    public static final String ERR_NAME_CHAR = "Only alphabet, number, [-_] allowed in name.";
    public static final String ERR_USERNAME_CHAR = "Only alphabet, number, [.@-_] allowed in username.";
    public static final String ERR_GRPNAME_CHAR = "Only alphabet, number, [-_] allowed in group name.";
    public static final String ERR_PASSWD_CHAR = "Only ASCII character allowed in password.";
    public static final String ERR_TOKEN_INVALID = "Not a valid token, only alphabet and number, length must be 8.";
    public static String ERR_NAME_LEN = "Name length must be between %s and %s.";
    public static String ERR_PASSWD_LEN = "Password length must be between %s and %s.";
    public static final String ERR_CLASSIFICATION_RULE_INVALID = "Not a valid classfication rule.";

    public static boolean isValidNameLen(String string) {
        return string.length() >= 1 && string.length() <= 64;
    }

    public static boolean isValidNameChar(String string) {
        return !string.matches(".*[^a-zA-Z0-9_\\-\u00e4\u00f6\u00fc].*");
    }

    public static boolean isValidUsernameChar(String string) {
        return !string.matches(".*[^a-zA-Z0-9\\.@_\\-\u00e4\u00f6\u00fc].*");
    }

    public static boolean isValidGrpnameChar(String string) {
        return !string.matches(".*[^a-zA-Z0-9\\_\\-\u00e4\u00f6\u00fc].*");
    }

    public static boolean isValidPasswdLen(String string) {
        return string.length() >= 1 && string.length() <= 128;
    }

    public static boolean isValidPasswdChar(String string) {
        return c.f(string);
    }

    public static boolean isDupWhitelistDomain(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from whitelist where domain = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupWhitelistKeyword(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from whitelist_kw where keyword = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupCategoryCustom(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from category_custom where name = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupGroup(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from grp where lower(name) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupPolicy(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from policy where lower(name) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupUser(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from user where lower(name) = ?", new Object[]{string.toLowerCase()});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupToken(int n2, String string) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from user where id <> ? and token = ?", new Object[]{n2, string.toUpperCase()});
        b2.close();
        return n3 > 0;
    }

    public static boolean isDupSubAdmin(String string) {
        if (string.equals("admin")) {
            return true;
        }
        try (b b2 = DaoUtil.getDbConfig();){
            int n2 = b2.f("select count(*) from sub_admin where lower(name) = ?", new Object[]{string.toLowerCase()});
            if (n2 > 0) {
                boolean bl = true;
                return bl;
            }
            String string2 = b2.e("select name from admin");
            if (string2.equals(string)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidToken(String string) {
        return string.matches(String.format("[a-zA-Z0-9]{%d}", 8));
    }

    public static boolean isValidBlockIp(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",|\\s+")) {
            if (nxd.lib.f.b(string2 = string2.trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMaxCustomDomain() {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from category_domain";
        int n2 = b2.f(string);
        b2.close();
        return n2 >= 300000;
    }

    public static boolean hasMaxCustomDomainForCategory(int n2) {
        b b2 = DaoUtil.getDbConfig();
        String string = "select count(*) from category_domain where category_id = " + n2;
        int n3 = b2.f(string);
        b2.close();
        return n3 >= 300000;
    }

    public static boolean isDupCategoryDomain(String string, int n2) {
        b b2 = DaoUtil.getDbConfig();
        int n3 = b2.f("select count(*) from category_domain where domain = ? and category_id = ?", new Object[]{string, n2});
        b2.close();
        return n3 > 0;
    }

    public static boolean isValidIp(String string) {
        return nxd.lib.f.b(string);
    }

    public static boolean isValidDomain(String string) {
        return nxd.lib.f.e(string);
    }

    public static boolean isValidEmail(String string) {
        return nxd.lib.f.g(string);
    }

    public static boolean isValidClassificationRule(String string) {
        if (string.contains("||") || string.contains("(|") || string.contains("|)")) {
            return false;
        }
        String string2 = string.replaceAll("\\\\.", "");
        if (string2.length() < 2) {
            return false;
        }
        try {
            Matcher matcher = Pattern.compile(string, 2).matcher("");
            return !matcher.find();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDupClassificationRule(String string, String string2, int n2) {
        int n3 = 0;
        try (b b2 = DaoUtil.getDbConfig();){
            n3 = b2.f("select count(*) from classifier_ruleset where target = ? and keyword = ? and category_id = ?", new Object[]{string, string2, n2});
        }
        return n3 > 0;
    }

    public static boolean isDupZoneFile(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from zone_file where domain = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isValidRepositoryUrl(String string) {
        return string.matches("https?://.*/.+\\.(txt|tgz|tar\\.gz)");
    }

    public static boolean isValidBlocklistUrl(String string) {
        return string.matches("https?://.*");
    }

    public static String findInvalidAllowedIp(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\\s+")) {
            String string3;
            String string4;
            String[] stringArray2;
            if ((string2 = string2.trim()).startsWith("px")) continue;
            if (string2.contains("/")) {
                try {
                    stringArray2 = new nxd.o.c(string2);
                    string4 = stringArray2.a();
                    string3 = stringArray2.b();
                    continue;
                }
                catch (Exception exception) {
                    return string2;
                }
            }
            if (string2.contains("-")) {
                stringArray2 = string2.split("-");
                if (stringArray2.length == 2) {
                    long l2;
                    string4 = stringArray2[0];
                    string3 = stringArray2[1];
                    long l3 = nxd.lib.f.k(string4);
                    if (l3 > (l2 = nxd.lib.f.k(string3))) {
                        return string2;
                    }
                    if (nxd.lib.f.b(string4) && nxd.lib.f.b(string3)) continue;
                }
                return string2;
            }
            if (nxd.lib.f.b(string2)) continue;
            return string2;
        }
        return "";
    }

    public static boolean isValidUpstreamDnsServer(String string) {
        if (!string.contains(":")) {
            return nxd.lib.f.b(string);
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 2) {
            return false;
        }
        if (!nxd.lib.f.b(stringArray[0])) {
            return false;
        }
        int n2 = c.d(stringArray[1]);
        return n2 > 0 && n2 <= 65535;
    }

    public static boolean isDupDhcpAllowedMac(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from dhcp_allowed_mac where mac = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDupDhcpDeniedMac(String string) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from dhcp_denied_mac where mac = ?", new Object[]{string});
        b2.close();
        return n2 > 0;
    }

    public static boolean isValidMac(String string) {
        return nxd.lib.f.d(string);
    }

    public static boolean isDupDhcpReservedIp(String string, String string2) {
        b b2 = DaoUtil.getDbConfig();
        int n2 = b2.f("select count(*) from dhcp_reserved_ip where ip = ? or mac = ?", new Object[]{string, string2});
        b2.close();
        return n2 > 0;
    }

    public static boolean isDhcpReservedIpOutOfRange(String string) {
        f f2 = f.a();
        long l2 = nxd.lib.f.k(string);
        return l2 < f2.s || l2 > f2.t;
    }

    static {
        ERR_NAME_LEN = String.format(ERR_NAME_LEN, 1, 64);
        ERR_PASSWD_LEN = String.format(ERR_PASSWD_LEN, 1, 128);
    }
}

