/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net;

import java.util.HashMap;
import java.util.Map;
import nettrack.net.IllegalAddress;
import nettrack.net.IllegalSubnet;
import nettrack.net.IpAddr;

public class Subnet {
    static Map mask2length;
    static Map length2mask;
    IpAddr network;
    Integer length;

    public static void main(String[] a) throws Exception {
        System.out.println(new Subnet(a[0]));
    }

    public Subnet(IpAddr network_, IpAddr mask) throws IllegalSubnet {
        this.length = (Integer)mask2length.get(new Long(mask.longValue()));
        if (this.length == null) {
            throw new IllegalSubnet(mask);
        }
        this.network = network_;
    }

    public Subnet(IpAddr network_, int length_) throws IllegalSubnet {
        this.network = network_;
        if (length_ < 0 || length_ > 32) {
            throw new IllegalSubnet(length_);
        }
        this.length = new Integer(length_);
    }

    public Subnet(String net) throws IllegalAddress {
        block5: {
            if (net == null) {
                throw new IllegalSubnet(net);
            }
            int s = net.indexOf(47);
            if (s == net.length()) {
                throw new IllegalSubnet(net);
            }
            String n = net.substring(0, s);
            String m = net.substring(s + 1, net.length());
            this.network = new IpAddr(n);
            try {
                this.length = new Integer(m);
                if (this.length < 0 || this.length > 32) {
                    throw new IllegalSubnet(this.length);
                }
            }
            catch (NumberFormatException e) {
                IpAddr mask = new IpAddr(m);
                this.length = (Integer)mask2length.get(new Long(mask.longValue()));
                if (this.length != null) break block5;
                throw new IllegalSubnet(mask);
            }
        }
    }

    public boolean containsAddr(IpAddr addr) {
        return this.network.longValue() == (addr.longValue() & (Long)length2mask.get(this.length));
    }

    public int getLength() {
        return this.length;
    }

    public IpAddr getMask() {
        return new IpAddr((Long)length2mask.get(this.length));
    }

    public IpAddr getNetwork() {
        return this.network;
    }

    public String toString() {
        return this.network.toString() + "/" + this.length.toString();
    }

    public int hashCode() {
        return this.network.hashCode();
    }

    static {
        int i;
        mask2length = new HashMap();
        length2mask = new HashMap();
        for (i = 0; i <= 32; ++i) {
            mask2length.put(new Long(-1L << i & 0xFFFFFFFFL), new Integer(32 - i));
        }
        for (i = 0; i <= 32; ++i) {
            length2mask.put(new Integer(32 - i), new Long(-1L << i & 0xFFFFFFFFL));
        }
    }
}

