/*
 * Decompiled with CFR 0.152.
 */
package nettrack.net.netflow;

import nettrack.net.IpAddr;
import nettrack.util.ByteUtil;

public abstract class Flow {
    protected byte[] data;
    protected int offset;

    public void setData(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public abstract int getLength();

    public long getSrcAddr() {
        return ByteUtil.getULong(this.data, this.offset + 0);
    }

    public long getDstAddr() {
        return ByteUtil.getULong(this.data, this.offset + 4);
    }

    public long getNextHop() {
        return ByteUtil.getULong(this.data, this.offset + 8);
    }

    public int getInputIf() {
        return ByteUtil.getUShort(this.data, this.offset + 12);
    }

    public int getOutputIf() {
        return ByteUtil.getUShort(this.data, this.offset + 14);
    }

    public long getDPkts() {
        return ByteUtil.getULong(this.data, this.offset + 16);
    }

    public long getDOctets() {
        return ByteUtil.getULong(this.data, this.offset + 20);
    }

    public long getFirst() {
        return ByteUtil.getULong(this.data, this.offset + 24);
    }

    public long getLast() {
        return ByteUtil.getULong(this.data, this.offset + 28);
    }

    public int getSrcPort() {
        return ByteUtil.getUShort(this.data, this.offset + 32);
    }

    public int getDstPort() {
        return ByteUtil.getUShort(this.data, this.offset + 34);
    }

    public String toString() {
        return "SrcAddr: " + IpAddr.toString(this.getSrcAddr()) + "\n" + "DstAddr: " + IpAddr.toString(this.getDstAddr()) + "\n" + "NextHop: " + IpAddr.toString(this.getNextHop()) + "\n" + "InputIf: " + this.getInputIf() + "\n" + "OutputIf: " + this.getOutputIf() + "\n" + "DPkts: " + this.getDPkts() + "\n" + "DOctets: " + this.getDOctets() + "\n" + "First: " + this.getFirst() + "\n" + "Last: " + this.getLast() + "\n" + "SrcPort: " + this.getSrcPort() + "\n" + "DstPort: " + this.getDstPort();
    }

    public String toShortString() {
        return IpAddr.toString(this.getSrcAddr()) + "." + this.getSrcPort() + " -> " + IpAddr.toString(this.getDstAddr()) + "." + this.getDstPort() + " " + this.getDOctets();
    }
}

