/*
 * Decompiled with CFR 0.152.
 */
package nettrack.util;

public abstract class AsyncBoundedFifo
extends Thread {
    int nextPut;
    int nextGet;
    boolean empty;
    boolean running = true;
    Object[] queue;

    public AsyncBoundedFifo(int queueSize) {
        this.queue = new Object[queueSize];
        this.empty = true;
        this.nextPut = 0;
        this.nextGet = 0;
        this.start();
    }

    public int getQueueSize() {
        return this.queue.length;
    }

    public synchronized void put(Object element) {
        if (!this.empty && this.nextPut == this.nextGet) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
        }
        this.queue[this.nextPut++] = element;
        this.nextPut %= this.queue.length;
        this.empty = false;
        this.notify();
    }

    public synchronized void run() {
        boolean go = true;
        while (go && this.running) {
            if (this.empty) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    System.err.println(e);
                }
            }
            if (!this.running) continue;
            Object element = this.queue[this.nextGet++];
            this.nextGet %= this.queue.length;
            this.empty = this.nextGet == this.nextPut;
            this.notify();
            go = this.handle(element);
        }
    }

    public synchronized void destroy() {
        this.running = false;
        this.notify();
    }

    public abstract boolean handle(Object var1);
}

