<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void delete(DhcpLeasedIpDao dao){
	if(dao.delete(paramInt("id"))){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
DhcpLeasedIpDao dao = new DhcpLeasedIpDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("delete")){
	delete(dao);
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("DHCP")%></li>
		<li class="breadcrumb-item text-info"><%= translate("LEASED IP")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- List -->
<div id="listDiv" class="container-fluid" style="display: none;">
	<div class="m-2 expand-lg">
		<table id="list" class="cell-border hover" style="width:100%">
			<thead>
				<tr>
					<th></th>
					<th><%= translate("IP")%></th>
					<th><%= translate("MAC")%></th>
					<th><%= translate("Hostname")%></th>
					<th><%= translate("Lease Time")%></th>
					<th><%= translate("Expire Time")%></th>
					<th></th>
				</tr>
			</thead>
			<tbody>
<%
List<DhcpLeasedIpData> dataList = dao.selectList();
for(int i = 0; i < dataList.size(); i++){
	DhcpLeasedIpData data = dataList.get(i);
%>
				<tr>
					<td></td>
					<td data-order="<%= data.ipNumeric %>"><%= data.ip%></td>
					<td><%= data.mac%></td>
					<td><%= data.hostname%></td>
					<td><%= data.getLeaseTimestamp()%></td>
					<td><%= data.getExpireTimestamp()%></td>
					<td>
						<i class="fa fa-trash pointer-cursor" title="<%= translate("Delete")%>" onclick="javascript:actionDelete(<%= data.id%>, '<%= data.ip%>')"></i>
					</td>
				</tr>
<%}%>
			</tbody>
		</table>
	</div>
</div>
<!-- /List -->

<!-- goForm -->
<form name="goForm" method="get">
<input type="hidden" name="actionFlag" value="">
<input type="hidden" name="id" value="">
</form>
<!-- /goForm -->

<%@include file="include/footer.jsp"%>

<script>
//-----------------------------------------------
$(document).ready(function(){
	$("#list").DataTable({
		"pageLength": 25,
		"lengthMenu": [[25, 50, 100], [25, 50, 100]],
		"bLengthChange" : true,
		"columnDefs": [{
			"targets": 0,
			"visible": false,
			"searchable": false,
		}],
		"initComplete": function(settings, json){
			$("#listDiv").show();
		},
		language : langMulti,
	});
});

//-----------------------------------------------
function actionDelete(id, ip){
	if(!confirm('<%= translate("Deleting IP")%> : ' +  ip)){
		return;
	}

	var form = document.goForm;
	form.actionFlag.value = "delete";
	form.id.value = id;
	form.submit();
}

//-----------------------------------------------
// Prevent submit again.
if(window.history.replaceState){
	window.history.replaceState(null, null, window.location.href);
}
</script>
