<%@include file="include/header.jsp"%>
<%!
//-----------------------------------------------
void update(PolicyNxProxyDao dao){
	PolicyNxProxyData data = dao.selectOne();

	data.enableFilter = paramBoolean("enableFilter");
	data.localDns = paramString("localDns");
	data.localDomain = paramString("localDomain");

	if(dao.update(data)){
		succList.add(translate("Update finished."));
	}
}

//-----------------------------------------------
void android(PolicyNxProxyDao dao){
	PolicyNxProxyData data = dao.selectOne();

	data.enableAndroid = paramBoolean("enableAndroid");
	data.bypassedPackages = paramString("bypassedPackages");

	if(dao.update(data)){
		succList.add(translate("Update finished."));
	}
}
%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();
permission.addSubAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
PolicyNxProxyDao dao = new PolicyNxProxyDao();

// Action.
String actionFlag = paramString("actionFlag");
if(actionFlag.equals("update")){
	update(dao);
}
if(actionFlag.equals("android")){
	android(dao);
}

// Global.
PolicyNxProxyData data = dao.selectOne();

// Active tab.
String tabActive0 = "";
String tabActive1 = "";

String showActive0 = "";
String showActive1 = "";

int tabIdx = paramInt("tabIdx");
if(tabIdx == 0){
	tabActive0 = " active";
	showActive0 = " show active";
}
else if(tabIdx == 1){
	tabActive1 = " active";
	showActive1 = " show active";
}

if(isGloblist()){
	warnList.add(translate("Globlist doesn't support NxProxy."));
}
%>
<!-- Action info -->
<%@include file="include/ab-notify.jsp"%>
<!-- /Action info -->

<!-- Breadcrumb -->
<div class="container-fluid primary" style="margin-top:-5px;">
	<ol class="breadcrumb" style="margin-left:10px; margin-right:10px;">
		<li class="breadcrumb-item"><%= translate("POLICY")%></li>
		<li class="breadcrumb-item text-info"><%= translate("NXPROXY")%></li>
	</ol>
</div>
<!-- /Breadcrumb -->

<!-- Main content -->
<div class="container-fluid">

	<!-- Form -->
	<form action="<%= getPageName()%>" method="post">
		<input type="hidden" id="actionFlag" name="actionFlag" value="<%= actionFlag%>">
		<input type="hidden" id="tabIdx" name="tabIdx" value="<%= tabIdx%>">

		<!-- Tab content -->
		<div id="myTabContent" class="tab-content">

			<!-- Windows -->
			<div class="tab-pane <%= showActive0%>" id="tab0">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8 text-secondary">
								 <%= translate("NxProxy is a remote filtering agent.")%>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="enableFilter"
										name="enableFilter" <%if(data.enableFilter){out.print("checked");}%>>
									<label for="enableFilter" class="custom-control-label"><%= translate("Enable Filter")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Local Domain")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("This is for bypassing local domains from filtering. Multiple domains must be separated by spaces.")%>
											<br>&nbsp;&nbsp;ex) www.nxfilter.local *.jahastech.local"></i>
								</label>
								<textarea class="form-control" id="localDomain" name="localDomain"><%= data.localDomain%></textarea>
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Local DNS Server")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("Normally you don't need this. NxProxy will find the DNS server in its network by itself.")%>"></i>
								</label>
								<input type="text" class="form-control" id="localDns" name="localDns"
									value="<%= data.localDns%>">
								<small id="input-help" class="form-text text-muted">
									<%= translate("Multiple IP addresses must be separated by commas.")%>
								</small>
							</div>
							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"
									onclick="javascript:this.form.actionFlag.value='update';"><%= translate("SUBMIT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Windows -->

			<!-- Android -->
			<div class="tab-pane fade<%= showActive1%>" id="tab1">
				<div class="card bg-light m-2 expand-lg">
					<div class="card-body">
						<fieldset>
							<div class="form-group col-lg-8 text-secondary">
								 <%= translate("This is for NxProxy for Android.")%>
							</div>
							<div class="form-group col-lg-8">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" id="enableAndroid"
										name="enableAndroid" <%if(data.enableAndroid){out.print("checked");}%>>
									<label for="enableAndroid" class="custom-control-label"><%= translate("Enable Filter")%></label>
								</div>
							</div>
							<div class="form-group col-lg-8">
								<label class="col-form-label">
									<%= translate("Bypassed Android Apps")%>
									&nbsp;<i class="fa fa-question-circle south-east"
										title="<%= translate("When you run NxProxy for Android, you can bypass certain apps from filtering by adding their package names here. Multiple package names must be separated by spaces.")%>"></i>
								</label>
								<textarea class="form-control" id="bypassedPackages" name="bypassedPackages" rows="10"><%= data.bypassedPackages%></textarea>
							</div>
							<div class="form-group col-lg-8">
								<button type="submit" class="btn btn-primary"
									onclick="javascript:this.form.actionFlag.value='android';"><%= translate("SUBMIT")%></button>
							</div>
						</fieldset>
					</div>
				</div>
			</div>
			<!-- /Android -->

		</div>
		<!-- Tab content -->

	</form>
	<!-- /Form -->

</div>
<!-- /Main content -->

<%@include file="include/footer.jsp"%>
