<%@include file="include/header.jsp"%>
<%
//-----------------------------------------------
// Set permission for this page.
permission.addAdmin();

//Check permission.
if(!checkPermission()){
	return;
}

// Create data access object.
ClassifierTestDao dao = new ClassifierTestDao();

// Global.
ClassifiedData data = dao.test(paramString("domain"));
%>
<%@include file="include/action_info.jsp"%>

<!-- view -->
<form action="<%= getPageName()%>" method="post">

<fieldset>
	<legend>TEST RUN</legend>
<table class="view">

	<tr>
		<td colspan="2">
		Test run for NxClassifier and its ruleset.
		</td>
	</tr>

	<tr>
		<td width="200">Domain</td>
		<td>
			<input type="text" name="domain" size="50" value="<%= data.domain%>">
		</td>
	</tr>

	<tr>
		<td></td>
		<td>
			<input type="button" value="SUBMIT" onclick="javascript:this.form.submit();">
			<input type="button" value="RESET" onclick="javascript:this.form.reset();">
		</td>
	</tr>

</table>
</fieldset>
</form>
<!-- /view -->

<!-- view -->
<%if(isNotEmpty(data.lastUrl) || isNotEmpty(data.errString)){%>
<form>
<fieldset>
	<legend>TEST RESULT</legend>
<table class="view">

	<%if(!data.errFlag){%>
	<tr>
		<td width="200">Last URL</td>
		<td>
			<%= data.lastUrl%>
		</td>
	</tr>

	<tr>
		<td>Character Set</td>
		<td>
			<%= data.charset%>
		</td>
	</tr>

	<tr>
		<td>Title</td>
		<td>
			<%= data.title%>
		</td>
	</tr>

	<tr>
		<td>Description</td>
		<td>
			<%= data.description%>
		</td>
	</tr>

	<tr>
		<td>Keywords</td>
		<td>
			<%= data.keywords%>
		</td>
	</tr>

	<tr>
		<td>Text</td>
		<td>
			<%= data.bodyText%>
		</td>
	</tr>

	<tr>
		<td>Category</td>
		<td>
			<%= data.categoryName%>
		</td>
	</tr>

	<tr>
		<td valign="top">Reason</td>
		<td>
			<%= data.reason.replaceAll("[\n;]", "<br>\n&nbsp;&nbsp;")%>
		</td>
	</tr>
	<%}%>

	<%if(isNotEmpty(data.errString)){%>
	<tr>
		<td>Error</td>
		<td>
			<%= data.errString%>
		</td>
	</tr>
	<%}%>

</table>
</fieldset>
</form>
<%}%>
<!-- /view -->

<%@include file="include/footer.jsp"%>
